<?php
// ajax/guardar_cobro_sala.php
ob_start(); // limpia buffers
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Variables sanitizadas o forzadas
$sala_id = intval($_POST['sala_id'] ?? 0);
$cliente = mysqli_real_escape_string($con, $_POST['cliente'] ?? 'Sin nombre');
$comentario = mysqli_real_escape_string($con, $_POST['comentario'] ?? '');
$monto = floatval($_POST['monto'] ?? 10.00);
$forma_pago = $_POST['forma_pago'] ?? 'efectivo';
$efectivo = floatval($_POST['efectivo'] ?? 10.00);
$transferencia = floatval($_POST['transferencia'] ?? 0.00);
$fecha = date('Y-m-d');
$hora = date('H:i:s');

// Generar ticket
$ticket_html = "<h3>Ticket</h3>";
$ticket_html .= "<p>Sala ID: $sala_id</p>";
$ticket_html .= "<p>Cliente: $cliente</p>";
$ticket_html .= "<p>Total: $" . number_format($monto, 2, ',', '.') . "</p>";
$ticket_html .= "<p>Forma de pago: $forma_pago</p>";

// Guardar en base
$sql = "INSERT INTO caja_sala (sala_id, fecha, hora, total, efectivo, transferencia, forma_pago, cliente, comentario, ticket_html)
VALUES ($sala_id, '$fecha', '$hora', $monto, $efectivo, $transferencia, '$forma_pago', '$cliente', '$comentario', '$ticket_html')";

if (mysqli_query($con, $sql)) {
    $ticket_id = mysqli_insert_id($con);
    ob_end_clean();
    header('Content-Type: application/json');
    $response = ['success' => true, 'ticket_id' => $ticket_id];
    file_put_contents('debug_response.txt', json_encode($response, JSON_PRETTY_PRINT));
    echo json_encode($response);
} else {
    ob_end_clean();
    header('Content-Type: application/json');
    $error = ['error' => 'Fallo al guardar en caja', 'mysql' => mysqli_error($con)];
    file_put_contents('debug_response.txt', json_encode($error, JSON_PRETTY_PRINT));
    echo json_encode($error);
}
exit;
?>
