<?php
// ajax/guardar_cobro_mesa.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$mesa_id = intval($_POST['mesa_id'] ?? 0);
$monto = floatval($_POST['monto'] ?? 0);
$cliente = trim($_POST['cliente'] ?? '');
$comentario = trim($_POST['comentario'] ?? '');
$forma_pago = $_POST['forma_pago'] ?? '';
$efectivo = floatval($_POST['efectivo'] ?? 0);
$transferencia = floatval($_POST['transferencia'] ?? 0);

if ($mesa_id <= 0 || $monto <= 0 || !in_array($forma_pago, ['efectivo', 'transferencia', 'dividido'])) {
  echo json_encode(['error' => 'Datos inválidos']);
  exit;
}

$fecha = date('Y-m-d');
$hora = date('H:i:s');

// Insertar en caja_mesa
$stmt = $con->prepare("INSERT INTO caja_mesa (mesa_id, cliente, comentario, monto_total, efectivo, transferencia, forma_pago, fecha, hora) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("issddssss", $mesa_id, $cliente, $comentario, $monto, $efectivo, $transferencia, $forma_pago, $fecha, $hora);
$stmt->execute();

$ticket_id = $stmt->insert_id;
$stmt->close();

echo json_encode(['success' => true, 'ticket_id' => $ticket_id]);
