<?php
// ver_ticket_sala.php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
$autoPrint = isset($_GET['print']);

if ($id <= 0) {
  echo "❌ ID inválido.";
  exit;
}

$sql = "SELECT cs.*, s.nombre AS sala_nombre
        FROM caja_sala cs
        LEFT JOIN salas s ON cs.sala_id = s.id
        WHERE cs.id = {$id} LIMIT 1";
$res = mysqli_query($con, $sql);
if (!$res || mysqli_num_rows($res) === 0) {
  echo "❌ Ticket no encontrado.";
  exit;
}

$ticket = mysqli_fetch_assoc($res);
$detalles = json_decode($ticket['detalles_json'] ?? '', true);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Sala #<?= htmlspecialchars($ticket['id']) ?></title>
  <style>
    body {
      font-family: 'Courier New', monospace;
      margin: 0;
      padding: 10px;
      font-size: 14px;
      width: 80mm;
      margin: 0 auto;
    }
    .ticket {
      border: 1px dashed #ccc;
      padding: 10px;
      background: white;
    }
    .header {
      text-align: center;
      margin-bottom: 10px;
      border-bottom: 1px dashed #000;
      padding-bottom: 10px;
    }
    .header h1 {
      font-size: 18px;
      margin: 5px 0;
      font-weight: bold;
    }
    .header p {
      margin: 3px 0;
      font-size: 12px;
    }
    .info {
      margin: 8px 0;
      font-size: 13px;
    }
    .info strong {
      display: inline-block;
      width: 100px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin: 8px 0;
      font-size: 13px;
    }
    th {
      text-align: left;
      border-bottom: 1px dashed #000;
      padding: 3px 0;
    }
    td {
      padding: 3px 0;
    }
    .right {
      text-align: right;
    }
    .total {
      font-weight: bold;
      border-top: 1px dashed #000;
      border-bottom: 1px double #000;
    }
    .separator {
      border-top: 1px dashed #000;
      margin: 5px 0;
    }
    .footer {
      text-align: center;
      margin-top: 10px;
      font-size: 11px;
    }
    button {
      background: #333;
      color: white;
      border: none;
      padding: 8px 15px;
      margin: 10px auto;
      display: block;
      cursor: pointer;
      border-radius: 3px;
    }
    @media print {
      button {
        display: none;
      }
      body {
        width: 80mm;
        margin: 0;
        padding: 0;
      }
    }
  </style>
</head>
<body>
<div class="ticket">
  <div class="header">
    <h1>HUM CLUB DE MÚSICA</h1>
    <p>Dirección: Bs As 1064</p>
    <p>Tel: tu viej4</p>
    <p>CUIT:tu viej0</p>
  </div>

  <div class="info">
    <strong>Ticket #:</strong> <?= htmlspecialchars($ticket['id']) ?><br>
    <strong>Fecha:</strong> <?= htmlspecialchars($ticket['fecha']) ?> <?= htmlspecialchars($ticket['hora']) ?><br>
    <strong>Sala:</strong> <?= htmlspecialchars($ticket['sala_nombre'] ?: $ticket['sala_id']) ?><br>
    <strong>Cliente:</strong> <?= htmlspecialchars($ticket['cliente'] ?: '-') ?><br>
    <strong>Pago:</strong> <?= htmlspecialchars($ticket['forma_pago']) ?>
    <?php if($ticket['forma_pago'] === 'dividido'): ?>
      (Efectivo $<?= number_format($ticket['efectivo'],2,',','.') ?> / Transf. $<?= number_format($ticket['transferencia'],2,',','.') ?>)
    <?php elseif($ticket['forma_pago'] === 'efectivo'): ?>
      - $<?= number_format($ticket['efectivo'],2,',','.') ?>
    <?php elseif($ticket['forma_pago'] === 'transferencia'): ?>
      - $<?= number_format($ticket['transferencia'],2,',','.') ?>
    <?php endif; ?>
  </div>

  <?php if($detalles): ?>
    <?php
      $precioSala = floatval($detalles['precio_sala'] ?? 0);
      $productos  = $detalles['productos'] ?? [];
      $alquileres = $detalles['alquileres'] ?? [];
      $descuento  = floatval($detalles['descuento'] ?? 0);
    ?>
    
    <div class="separator"></div>
    
    <table>
      <tr><th colspan="2">RESUMEN DE TURNO</th></tr>
      <tr><td>Hora inicio:</td><td class="right"><?= htmlspecialchars($detalles['hora_inicio'] ?? '-') ?></td></tr>
      <tr><td>Hora fin:</td><td class="right"><?= htmlspecialchars($detalles['hora_fin'] ?? '-') ?></td></tr>
      <tr><td>Duración:</td><td class="right">
        <?php
          $dur = $detalles['duracion'] ?? '';
          if(is_numeric($dur)){
            $h = floor($dur/60);
            $m = $dur % 60;
            echo ($h ? $h.'h ' : '').$m.'m';
          } else {
            echo htmlspecialchars($dur ?: '-');
          }
        ?>
      </td></tr>
      <tr><td>Precio Sala:</td><td class="right">$<?= number_format($precioSala,2,',','.') ?></td></tr>
    </table>

    <?php if($productos): ?>
      <div class="separator"></div>
      <table>
        <tr><th colspan="2">PRODUCTOS</th></tr>
        <?php foreach($productos as $p): ?>
          <tr>
            <td><?= htmlspecialchars($p['nombre']) ?></td>
            <td class="right">$<?= number_format($p['precio'] ?? 0,2,',','.') ?></td>
          </tr>
        <?php endforeach; ?>
      </table>
    <?php endif; ?>

    <?php if($alquileres): ?>
      <div class="separator"></div>
      <table>
        <tr><th colspan="2">ALQUILERES</th></tr>
        <?php foreach($alquileres as $a): ?>
          <tr>
            <td><?= htmlspecialchars($a['nombre']) ?></td>
            <td class="right">$<?= number_format($a['precio'] ?? 0,2,',','.') ?></td>
          </tr>
        <?php endforeach; ?>
      </table>
    <?php endif; ?>

    <div class="separator"></div>
    <table>
      <tr><td>Subtotal:</td><td class="right">
        $<?php
          $sub = $precioSala;
          foreach($productos as $p){ $sub += floatval($p['precio'] ?? 0); }
          foreach($alquileres as $a){ $sub += floatval($a['precio'] ?? 0); }
          echo number_format($sub,2,',','.');
        ?>
      </td></tr>
      <tr><td>Descuento:</td><td class="right">- $<?= number_format($descuento,2,',','.') ?></td></tr>
      <tr class="total"><td>TOTAL:</td><td class="right">$<?= number_format($ticket['total'],2,',','.') ?></td></tr>
    </table>
  <?php else: ?>
    <div class="separator"></div>
    <p><em>Este ticket no contiene detalle JSON. Sólo se muestra información básica.</em></p>
  <?php endif; ?>

  <div class="footer">
    <p>¡Gracias por tu visita!</p>
    <p>www.humclubdemusica.com.ar</p>
  </div>
</div>

<button onclick="window.print()">🖨 Imprimir Ticket</button>

<?php if($autoPrint): ?>
<script> window.print(); </script>
<?php endif; ?>
</body>
</html>