<?php
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$id = intval($_GET['id'] ?? 0);
$autoPrint = isset($_GET['print']);

if ($id <= 0) {
  echo "❌ ID inválido.";
  exit;
}

/**
 * Intenta obtener el ticket desde caja_mesa (nuevo esquema con detalles_json).
 * Si no existe, intenta desde tickets_mesa (esquema legacy).
 */
$ticket = null;
$desde  = ''; // indica desde qué tabla se extrajo

// ---------- 1) Buscar en caja_mesa ----------
$sql = "SELECT * FROM caja_mesa WHERE id = $id LIMIT 1";
if ($res = mysqli_query($con, $sql)) {
  if (mysqli_num_rows($res) > 0) {
    $ticket = mysqli_fetch_assoc($res);
    $ticket['detalles_json'] = $ticket['detalles_json'] ?? '{}';
    $desde  = 'caja';
  }
  mysqli_free_result($res);
}

// ---------- 2) Buscar en tickets_mesa ----------
if (!$ticket) {
  $sql = "SELECT * FROM tickets_mesa WHERE id = $id LIMIT 1";
  if ($res = mysqli_query($con, $sql)) {
    if (mysqli_num_rows($res) > 0) {
      $ticket = mysqli_fetch_assoc($res);
      $desde  = 'tickets';
    }
    mysqli_free_result($res);
  }
}

if (!$ticket) {
  echo "❌ Ticket no encontrado.";
  exit;
}

// ---------- Procesar detalle de productos ----------
$productos = [];
$descuento = 0;

if ($desde === 'caja') {
  $detalles = json_decode($ticket['detalles_json'] ?? '{}', true);
  $productos = $detalles['productos'] ?? [];
  $descuento = floatval($detalles['descuento'] ?? 0);

  // Completar nombre/cantidad si faltan
  foreach ($productos as &$prod) {
    if (empty($prod['nombre'])) {
      $pid = intval($prod['id'] ?? 0);
      if ($pid > 0) {
        $nameRes = mysqli_query($con, "SELECT nombre FROM productos_mesas WHERE id = $pid LIMIT 1");
        if ($nameRes && mysqli_num_rows($nameRes) == 0) {
          // intentar en tabla productos (por si se guardó desde sala u otra fuente)
          $nameRes = mysqli_query($con, "SELECT nombre FROM productos WHERE id = $pid LIMIT 1");
        }
        if ($nameRes && mysqli_num_rows($nameRes) > 0) {
          $rowName = mysqli_fetch_row($nameRes);
          $prod['nombre'] = $rowName[0];
        }
      }
    }
    if (!isset($prod['cantidad'])) {
      $prod['cantidad'] = 1;
    }
  }
  unset($prod);
} else {
  // tickets_mesa: buscar en tickets_mesa_detalle
  $detalleSql = "SELECT d.producto_id, d.precio,
                        COALESCE(p.nombre, pm.nombre, CONCAT('ID ', d.producto_id)) AS nombre
                 FROM tickets_mesa_detalle d
                 LEFT JOIN productos p        ON p.id  = d.producto_id
                 LEFT JOIN productos_mesas pm ON pm.id = d.producto_id
                 WHERE d.ticket_id = $id";
  $detalleRes = mysqli_query($con, $detalleSql);
  while ($row = mysqli_fetch_assoc($detalleRes)) {
    $productos[] = [
      'id'       => intval($row['producto_id']),
      'nombre'   => $row['nombre'],
      'precio'   => floatval($row['precio']),
      'cantidad' => 1
    ];
  }
  mysqli_free_result($detalleRes);
  $descuento = floatval($ticket['descuento'] ?? 0);
}

// ---------- Render HTML ----------
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ticket Mesa #<?= $ticket['id'] ?></title>
  <style>
    body { font-family: monospace; font-size: 14px; padding: 10px; max-width: 300px; margin: auto; }
    h2 { text-align: center; }
    .linea { border-top: 1px dashed #000; margin: 8px 0; }
    .totales { margin-top: 10px; }
    .btns { margin-top: 20px; display: flex; justify-content: space-between; }
    @media print { .btns { display: none; } }
  </style>
</head>
<body>

<h2>🍽 Ticket Mesa</h2>
Mesa: <?= htmlspecialchars($ticket['mesa_id']) ?><br>
Fecha: <?= htmlspecialchars($ticket['fecha'] ?? date('Y-m-d')) ?><br>
Hora: <?= htmlspecialchars($ticket['hora']  ?? date('H:i:s')) ?><br>
Cliente: <?= htmlspecialchars($ticket['cliente'] ?: '-') ?><br>
Comentario: <?= htmlspecialchars($ticket['comentario'] ?: '-') ?>

<div class="linea"></div>

<b>Productos:</b><br>
<?php if (count($productos) > 0): ?>
  <ul>
    <?php foreach ($productos as $p): ?>
      <?php
        $nombre   = htmlspecialchars($p['nombre'] ?? 'Producto');
        $precio   = floatval($p['precio'] ?? 0);
        $cantidad = intval($p['cantidad'] ?? 1);
        $subtotal = $precio * $cantidad;
      ?>
      <li><?= $nombre ?> x<?= $cantidad ?> - $<?= number_format($subtotal, 2) ?></li>
    <?php endforeach; ?>
  </ul>
<?php else: ?>
  <i>Sin detalle</i><br>
<?php endif; ?>

<?php if ($descuento > 0): ?>
  <b>Descuento:</b> <?= number_format($descuento, 2) ?>%<br>
<?php endif; ?>

<div class="linea"></div>

<div class="totales">
  <b>Total:</b> $<?= number_format($ticket['monto_total'] ?? $ticket['total'], 2) ?><br>
  <b>Forma de pago:</b> <?= ucfirst($ticket['forma_pago']) ?><br>
  <?php if (($ticket['forma_pago'] ?? '') === 'dividido'): ?>
    💵 Efectivo: $<?= number_format($ticket['efectivo'], 2) ?><br>
    💳 Transferencia: $<?= number_format($ticket['transferencia'], 2) ?><br>
  <?php endif; ?>
</div>

<div class="btns">
  <button onclick="window.print()">🖨 Imprimir</button>
  <a href="index.php">🔙 Volver</a>
</div>

<?php if ($autoPrint): ?>
<script>window.onload = () => window.print();</script>
<?php endif; ?>
</body>
</html>