
<?php
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$mesaId = 1; // Mesa fija
$mesa = mysqli_fetch_assoc(mysqli_query($con, "SELECT * FROM mesas WHERE id=$mesaId LIMIT 1"));
$productos = mysqli_fetch_all(mysqli_query($con, "SELECT * FROM productos_mesas WHERE visible = 1 ORDER BY nombre ASC"), MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Mesa <?= htmlspecialchars($mesa['numero'] ?? $mesaId) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.card-mesa { max-width: 340px; margin:auto; }
.lista-productos-mesa li { font-size: 0.9rem; }
.btn-remove { margin-left: 6px; }
.ticket-box { background:#f8f9fa; border:1px solid #dee2e6; border-radius:6px; padding:6px 10px; font-size:0.9rem;}
</style>
</head>
<body>
<div class="card p-3 card-mesa" id="card_mesa_<?= $mesaId ?>">
  <form id="form_mesa_<?= $mesaId ?>">
    <h5 class="mb-1">Mesa <?= htmlspecialchars($mesa['numero'] ?? $mesaId) ?></h5>
    <?php if(!empty($mesa['ubicacion'])): ?>
      <p class="text-muted small mb-2"><?= htmlspecialchars($mesa['ubicacion']) ?></p>
    <?php endif; ?>

    <div class="mb-2">
      <label class="form-label">Cliente</label>
      <input type="text" class="form-control" name="cliente">
    </div>

    <div class="mb-2">
      <label class="form-label">Hora</label>
      <input type="time" class="form-control" name="hora" value="<?= date('H:i') ?>">
    </div>

    <div class="mb-2">
      <label class="form-label">Productos</label>
      <select class="form-select producto-mesa-select">
        <option value="">-- Agregar producto --</option>
        <?php foreach($productos as $p): ?>
          <option value="<?= $p['id'] ?>" data-precio="<?= $p['precio'] ?>">
            <?= htmlspecialchars($p['nombre']) ?> ($<?= number_format($p['precio'],2) ?>)
          </option>
        <?php endforeach; ?>
      </select>
      <ul class="list-group mt-1 lista-productos-mesa" id="productos_mesa_<?= $mesaId ?>"></ul>
    </div>

    <div class="ticket-box mb-2" id="ticket_mesa_<?= $mesaId ?>">
      Ticket:
      <div>Productos: -</div>
      <div>Total: $0</div>
    </div>

    <button type="button" class="btn btn-success btn-sm w-100" onclick="abrirModalCobroMesa(<?= $mesaId ?>)">💰 Cerrar mesa y cobrar</button>
  </form>
</div>

<!-- Modal Cobro Mesa -->
<div class="modal fade" id="modalCobroMesa" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content p-3">
      <h5 class="mb-3">💰 Cerrar Mesa y Cobrar</h5>
      <form id="formCobroMesa">
        <input type="hidden" name="mesa_id" id="mesa-id">
        <input type="hidden" name="monto" id="mesa-monto">

        <div class="mb-2">
          <label class="form-label">Cliente</label>
          <input type="text" class="form-control" id="mesa-cliente" name="cliente">
        </div>

        <div class="mb-2">
          <label class="form-label">Comentario</label>
          <textarea class="form-control" id="mesa-comentario" name="comentario" rows="2"></textarea>
        </div>

        <div class="mb-2">
          <label class="form-label">Total</label>
          <input type="text" class="form-control" id="mesa-total-visible" disabled>
        </div>

        <div class="mb-2">
          <label class="form-label">Forma de pago</label>
          <select class="form-select" id="mesa-forma-pago" name="forma_pago" required>
            <option value="">Seleccionar</option>
            <option value="efectivo">Efectivo</option>
            <option value="transferencia">Transferencia</option>
            <option value="dividido">Dividido</option>
          </select>
        </div>

        <div class="row mb-2" id="mesa-dividido" style="display:none;">
          <div class="col">
            <label class="form-label">Efectivo</label>
            <input type="number" step="0.01" class="form-control" id="mesa-efectivo" name="efectivo">
          </div>
          <div class="col">
            <label class="form-label">Transferencia</label>
            <input type="number" step="0.01" class="form-control" id="mesa-transferencia" name="transferencia">
          </div>
        </div>

        <div class="d-flex justify-content-end gap-2">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary">Cobrar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>
const MESA_ID = 1;
const STORAGE_KEY = 'form_mesa_' + MESA_ID;

/* ----------- Helpers ----------- */
function colectarDatos(){
    const data = {
        cliente: $('[name="cliente"]').val(),
        hora: $('[name="hora"]').val(),
        productos: $('#productos_mesa_'+MESA_ID+' li').map(function(){
            return {
                id: $(this).data('id'),
                nombre: $(this).data('nombre'),
                precio: $(this).data('precio')
            };
        }).get()
    };
    return data;
}

function guardarEstado(){
    const data = colectarDatos();
    const json = JSON.stringify(data);
    localStorage.setItem(STORAGE_KEY, json);
    saveToServer(json);
}

let saveTimeout;
function saveToServer(json){
    clearTimeout(saveTimeout);
    saveTimeout = setTimeout(()=>{
        fetch('/ajax/guardar_estado_mesa.php', {
            method:'POST',
            headers:{'Content-Type':'application/json'},
            body: JSON.stringify({id_mesa: MESA_ID, estado: json})
        }).catch(()=>{});
    }, 800);
}

function restaurarEstado(){
    const json = localStorage.getItem(STORAGE_KEY);
    if(json){
        try{
            const data = JSON.parse(json);
            $('[name="cliente"]').val(data.cliente||'');
            $('[name="hora"]').val(data.hora||'');
            $('#productos_mesa_'+MESA_ID).empty();
            (data.productos||[]).forEach(p=>{
                agregarProductoALaLista(p.id, p.nombre, p.precio, false);
            });
            actualizarTicket();
        }catch(e){}
    }else{
        fetch('/ajax/obtener_estado_mesa.php?id='+MESA_ID)
          .then(r=>r.json())
          .then(r=>{
              if(r.success && r.estado){
                  localStorage.setItem(STORAGE_KEY, r.estado);
                  restaurarEstado();
              }
          });
    }
}

function agregarProductoALaLista(id,nombre,precio,desdeSelect=true){
    $('#productos_mesa_'+MESA_ID).append(
        `<li class="list-group-item d-flex justify-content-between align-items-center"
             data-id="${id}" data-precio="${precio}" data-nombre="${nombre}">
            ${nombre} <span>$${precio.toFixed(2)}</span>
            <button type="button" class="btn btn-sm btn-outline-danger btn-remove">🗑</button>
        </li>`
    );
    if(desdeSelect){
        actualizarTicket();
        guardarEstado();
    }
}

function actualizarTicket(){
    let total = 0;
    let detalle = '';
    $('#productos_mesa_'+MESA_ID+' li').each(function(){
        const nombre = $(this).data('nombre');
        const precio = parseFloat($(this).data('precio'));
        total += precio;
        detalle += `<div>${nombre}: $${precio.toFixed(2)}</div>`;
    });
    if(detalle === '') detalle = '<div>Productos: -</div>';
    $('#ticket_mesa_'+MESA_ID).html(`Ticket:${detalle}<div>Total: $${total.toFixed(2)}</div>`);
    $('.cobrar-btn').data('total', total.toFixed(2));
}

/* ----------- Event Listeners ----------- */
$(document).on('change', '.producto-mesa-select', function(){
    const idProd = $(this).val();
    if(!idProd) return;
    const selected = $(this).find('option:selected');
    const nombre   = selected.text();
    const precio   = parseFloat(selected.data('precio'));
    agregarProductoALaLista(idProd, nombre, precio);
    $(this).val('');
});

$(document).on('click', '#productos_mesa_'+MESA_ID+' .btn-remove', function(){
    $(this).closest('li').remove();
    actualizarTicket();
    guardarEstado();
});

$('#form_mesa_'+MESA_ID+' :input').on('input', guardarEstado);

/* ----------- Finalizar Card ----------- */
function finalizarMesaCard(idMesa){
    $('#form_mesa_'+idMesa)[0].reset();
    $('#productos_mesa_'+idMesa).empty();
    $('#ticket_mesa_'+idMesa).html('Ticket:<div>Productos: -</div><div>Total: $0</div>');
    localStorage.removeItem(STORAGE_KEY);
    // opcional: pedir al servidor que borre
}

/* ----------- Init ----------- */
$(document).ready(function(){
    restaurarEstado();
});
/* ---------- Ticket ---------- */
function actualizarTicketMesa(mesaId){
  let total = 0;
  let detalle = '';
  $('#productos_mesa_'+mesaId+' li').each(function(){
    const txt = $(this).data('nombre') || $(this).text().trim();
    const precio = parseFloat($(this).data('precio'));
    total += precio;
    detalle += `<div>${txt}: $${precio.toFixed(2)}</div>`;
  });
  if(detalle === '') detalle = '<div>Productos: -</div>';
  $('#ticket_mesa_'+mesaId).html(\`
    Ticket:\${detalle}<div class="fw-bold">Total: $${total.toFixed(2)}</div>
  \`);
}
</script>

</body>
</html>



