<?php
require '../conexion.php';
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>🧾 Tickets de Mesas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4">
    <h3 class="mb-4">🧾 Historial de Tickets - Mesas</h3>

    <?php
    $tickets = $mysqli->query("SELECT * FROM tickets_mesa ORDER BY fecha DESC");

    while ($t = $tickets->fetch_assoc()):
      $id = $t['id'];
      $productos = [];
      $res = $mysqli->query("SELECT nombre, precio FROM tickets_mesa_detalle WHERE ticket_id = $id");
      while ($p = $res->fetch_assoc()) {
        $productos[] = $p;
      }
    ?>
      <div class="card mb-4 shadow-sm">
        <div class="card-header d-flex justify-content-between">
          <strong>#<?= $t['id'] ?> - <?= date("d/m/Y H:i", strtotime($t['fecha'])) ?></strong>
          <span class="badge bg-secondary"><?= ucfirst($t['forma_pago']) ?></span>
        </div>
        <div class="card-body">
          <p><strong>Mesa:</strong> <?= $t['mesa_id'] ?></p>
          <p><strong>Cliente:</strong> <?= htmlspecialchars($t['cliente']) ?></p>
          <p><strong>Comentario:</strong> <?= nl2br(htmlspecialchars($t['comentario'])) ?></p>
          <p><strong>Productos:</strong></p>
          <ul class="list-group mb-3">
            <?php foreach ($productos as $p): ?>
              <li class="list-group-item d-flex justify-content-between">
                <?= htmlspecialchars($p['nombre']) ?>
                <span>$<?= number_format($p['precio'], 2) ?></span>
              </li>
            <?php endforeach; ?>
          </ul>
          <p><strong>Descuento:</strong> $<?= number_format($t['descuento'], 2) ?></p>
          <p><strong>Total:</strong> $<?= number_format($t['total'], 2) ?></p>
          <div class="d-flex gap-3">
            <span class="badge bg-success">Efectivo: $<?= number_format($t['efectivo'], 2) ?></span>
            <span class="badge bg-info text-dark">Transferencia: $<?= number_format($t['transferencia'], 2) ?></span>
          </div>
        </div>
      </div>
    <?php endwhile; ?>

  </div>
</body>
</html>
