<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$desde = $_GET['desde'] ?? date('Y-m-01');
$hasta = $_GET['hasta'] ?? date('Y-m-d');

$query = "SELECT * FROM caja_sala WHERE fecha BETWEEN '$desde' AND '$hasta' ORDER BY fecha DESC, hora DESC";
$resultado = mysqli_query($con, $query);
$caja = [];
$total_efectivo = 0;
$total_transferencia = 0;

while ($row = mysqli_fetch_assoc($resultado)) {
    $caja[] = $row;
    $total_efectivo += floatval($row['efectivo']);
    $total_transferencia += floatval($row['transferencia']);
}
$total_general = $total_efectivo + $total_transferencia;
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Administrar Caja</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
</head>
<body class="p-4">
  <div class="container">
    <h2 class="mb-4">💵 Administración de Caja</h2>

    <form method="get" class="row g-3 mb-4">
      <div class="col-auto">
        <label>Desde</label>
        <input type="date" name="desde" class="form-control" value="<?= htmlspecialchars($desde) ?>">
      </div>
      <div class="col-auto">
        <label>Hasta</label>
        <input type="date" name="hasta" class="form-control" value="<?= htmlspecialchars($hasta) ?>">
      </div>
      <div class="col-auto mt-4">
        <button type="submit" class="btn btn-primary">Filtrar</button>
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#modalMovimiento">➕ Ingreso / Egreso</button>
        <button type="button" class="btn btn-danger" id="btnReiniciar">🧨 Reiniciar Caja</button>
      </div>
    </form>

    <div class="mb-4">
      <h5>Totales</h5>
      <p>Efectivo: <strong>$<?= number_format($total_efectivo, 2) ?></strong></p>
      <p>Transferencia: <strong>$<?= number_format($total_transferencia, 2) ?></strong></p>
      <p>Total: <strong>$<?= number_format($total_general, 2) ?></strong></p>
    </div>

    <div class="accordion" id="acordeonCaja">
      <?php foreach ($caja as $i => $mov): ?>
      <div class="accordion-item">
        <h2 class="accordion-header" id="heading<?= $i ?>">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?= $i ?>">
            <?= $mov['fecha'] ?> <?= $mov['hora'] ?> - <?= $mov['cliente'] ?: 'Sin cliente' ?> - $<?= number_format($mov['total'], 2) ?> (<?= $mov['forma_pago'] ?>)
          </button>
        </h2>
        <div id="collapse<?= $i ?>" class="accordion-collapse collapse" data-bs-parent="#acordeonCaja">
          <div class="accordion-body">
            <p><strong>Comentario:</strong> <?= nl2br(htmlspecialchars($mov['comentario'])) ?></p>
            <?php if (!empty($mov['ticket_html'])): ?>
              <div class="border p-2"><?= $mov['ticket_html'] ?></div>
              <a href="../ver_ticket.php?id=<?= $mov['id'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary mt-2">Ver ticket completo</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>

  <!-- Modal Ingreso/Egreso -->
  <div class="modal fade" id="modalMovimiento" tabindex="-1">
    <div class="modal-dialog">
      <form method="post" action="guardar_movimiento_manual.php" class="modal-content">
        <div class="modal-header"><h5 class="modal-title">➕ Ingreso / Egreso Manual</h5></div>
        <div class="modal-body">
          <label>Monto</label>
          <input type="number" name="monto" class="form-control mb-2" step="0.01" required>
          <label>Tipo</label>
          <select name="tipo" class="form-select mb-2">
            <option value="ingreso">Ingreso</option>
            <option value="egreso">Egreso</option>
          </select>
          <label>Forma de pago</label>
          <select name="forma_pago" class="form-select mb-2">
            <option value="efectivo">Efectivo</option>
            <option value="transferencia">Transferencia</option>
          </select>
          <label>Comentario</label>
          <textarea name="comentario" class="form-control"></textarea>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Guardar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.getElementById("btnReiniciar").addEventListener("click", function() {
  if (confirm("¿Seguro que querés reiniciar la caja? Esto agregará un ajuste negativo pero no borra los tickets.")) {
    fetch("reiniciar_caja.php", { method: "POST" })
      .then(r => r.text())
      .then(txt => {
        alert("Caja reiniciada correctamente");
        location.reload();
      });
  }
});
</script>
</body>
</html>
