<?php
require 'conexion.php';
$id = $_GET['id'] ?? 0;

// Buscar propiedad
$stmt = $conn->prepare("SELECT * FROM propiedades WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$resultado = $stmt->get_result();

if ($resultado->num_rows === 0) {
  echo "<p>Propiedad no encontrada.</p>";
  exit;
}

$propiedad = $resultado->fetch_assoc();

// Buscar imágenes adicionales
$stmt_imgs = $conn->prepare("SELECT * FROM imagenes_propiedades WHERE propiedad_id = ? ORDER BY orden ASC");
$stmt_imgs->bind_param("i", $id);
$stmt_imgs->execute();
$imagenes_result = $stmt_imgs->get_result();
$imagenes = $imagenes_result->fetch_all(MYSQLI_ASSOC);

$stmt->close();
$stmt_imgs->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?php echo htmlspecialchars($propiedad['titulo']); ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Navbar inyectada manualmente -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand" href="index.php">Inmobiliaria</a>
  </div>
</nav>

<div class="container py-5">
  <h1 class="mb-4"><?php echo htmlspecialchars($propiedad['titulo']); ?></h1>

  <?php if (!empty($propiedad['imagen'])): ?>
    <img src="uploads/<?php echo htmlspecialchars($propiedad['imagen']); ?>" class="img-fluid mb-4" alt="Imagen principal">
  <?php endif; ?>

  <p><strong>Tipo:</strong> <?php echo htmlspecialchars($propiedad['tipo']); ?></p>
  <p><strong>Operación:</strong> <?php echo htmlspecialchars($propiedad['operacion']); ?></p>
  <p><strong>Ambientes:</strong> <?php echo htmlspecialchars($propiedad['ambientes']); ?></p>
  <p><strong>Ubicación:</strong> <?php echo htmlspecialchars($propiedad['barrio']) . ', ' . htmlspecialchars($propiedad['localidad']); ?></p>
  <p><strong>Precio:</strong> $<?php echo number_format($propiedad['precio'], 2); ?></p>
  <p><strong>Descripción:</strong><br><?php echo nl2br(htmlspecialchars($propiedad['descripcion'])); ?></p>

  <?php if (!empty($imagenes)): ?>
    <h4 class="mt-5">Galería de Imágenes</h4>
    <div id="carouselGaleria" class="carousel slide mb-5" data-bs-ride="carousel">
      <div class="carousel-inner">
        <?php foreach ($imagenes as $i => $img): ?>
          <div class="carousel-item <?php if ($i === 0) echo 'active'; ?>">
            <img src="uploads/<?php echo htmlspecialchars($img['archivo']); ?>" 
                 class="d-block w-100 img-fluid object-fit-contain"
                 style="max-height:500px; margin:auto;" 
                 alt="Imagen <?php echo $i + 1; ?>">
          </div>
        <?php endforeach; ?>
      </div>
      <button class="carousel-control-prev" type="button" data-bs-target="#carouselGaleria" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#carouselGaleria" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>
    </div>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
