<?php

$para = 'lagarpropiedades@gmail.com';  
// ==============================


$propiedad_id      = (int)($_POST['propiedad_id'] ?? 0);
$propiedad_resumen = strip_tags($_POST['propiedad_resumen'] ?? 'Propiedad sin datos');

$nombre   = strip_tags($_POST['nombre'] ?? '');
$email    = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
$telefono = strip_tags($_POST['telefono'] ?? '');
$mensaje_raw = strip_tags($_POST['mensaje'] ?? '');
$mensaje_db  = $mensaje_raw;                 
$mensaje  = nl2br($mensaje_raw);           

require 'conexion.php';
$stmtC = $conn->prepare("INSERT INTO consultas (propiedad_id, nombre, email, telefono, mensaje, fecha)
                         VALUES (?,?,?,?,?,NOW())");
$stmtC->bind_param("issss", $propiedad_id, $nombre, $email, $telefono, $mensaje_db);
$stmtC->execute();
$stmtC->close();
$conn->close();


$asunto       = "📩 Consulta por: " . $propiedad_resumen;
$nombre_envio = "Sitio Web";
$email_reply  = "no-responder@netfan.host";

$html = "
    <h3>Consulta sobre: {$propiedad_resumen}</h3>
    <p><strong>Nombre:</strong> {$nombre}</p>
    <p><strong>Email:</strong> {$email}</p>
    <p><strong>Teléfono:</strong> {$telefono}</p>
    <p><strong>Mensaje:</strong><br>{$mensaje}</p>
    <hr>
    <p>ID Propiedad: {$propiedad_id}</p>
";

$post = [
    'html'          => base64_encode($html),
    'asunto'        => base64_encode($asunto),
    'nombre_envio'  => base64_encode($nombre_envio),
    'email_reply'   => base64_encode($email_reply),
    'nombre'        => base64_encode($nombre),
    'para'          => base64_encode($para)
];

$ch = curl_init("https://envios.netfan.com.ar/mailer.php");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
$response  = curl_exec($ch);
$httpcode  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$response_clean = strtoupper(trim(strip_tags($response))); // "<font>OK" → "OK"


$destino = "propiedad.php?id={$propiedad_id}";

if ($httpcode === 200 && $response_clean === 'OK') {
    header("Location: {$destino}&ok=1");
} else {
    header("Location: {$destino}&error=1");
}
exit;
?>
