<?php
session_start();
if (!isset($_SESSION['admin'])) { header('Location: login.php'); exit; }

require '../conexion.php';

$id = $_GET['id'] ?? 0;
$stmt = $conn->prepare("SELECT * FROM propiedades WHERE id = ?");
$stmt->bind_param("i",$id);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows === 0) { echo "Propiedad no encontrada"; exit; }
$p = $res->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Editar propiedad #<?php echo $p['id']; ?> | Inmobiliaria</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <style>
    :root {
      --primary-color: #2c3e50;
      --secondary-color: #3498db;
      --accent-color: #e74c3c;
      --success-color: #27ae60;
      --light-bg: #f8f9fa;
      --dark-text: #2c3e50;
      --light-text: #7f8c8d;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      color: var(--dark-text);
      background-color: #f5f7fa;
    }
    
    .navbar {
      background-color: var(--primary-color) !important;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .navbar-brand {
      font-weight: 500;
      display: flex;
      align-items: center;
    }
    
    .navbar-text {
      font-size: 1rem;
      opacity: 0.9;
    }
    
    .edit-form {
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 4px 20px rgba(0,0,0,0.08);
      border: none;
      background-color: white;
    }
    
    .form-header {
      padding: 1.5rem;
      background-color: var(--primary-color);
      color: white;
      margin: -1rem -1rem 1.5rem -1rem;
    }
    
    .form-title {
      font-weight: 600;
      margin: 0;
      display: flex;
      align-items: center;
    }
    
    .form-title i {
      margin-right: 0.75rem;
    }
    
    .form-label {
      font-weight: 500;
      margin-bottom: 0.5rem;
      color: var(--dark-text);
    }
    
    .btn-save {
      background-color: var(--success-color);
      border-color: var(--success-color);
      font-weight: 500;
      padding: 0.5rem 1.5rem;
      transition: all 0.3s;
    }
    
    .btn-save:hover {
      background-color: #219653;
      border-color: #219653;
      transform: translateY(-2px);
    }
    
    .btn-cancel {
      padding: 0.5rem 1.5rem;
      transition: all 0.3s;
    }
    
    .form-control, .form-select {
      border-radius: 6px;
      padding: 0.5rem 0.75rem;
      border: 1px solid #ddd;
    }
    
    .form-control:focus, .form-select:focus {
      border-color: var(--secondary-color);
      box-shadow: 0 0 0 0.25rem rgba(52, 152, 219, 0.25);
    }
    
    textarea.form-control {
      min-height: 150px;
    }
    
    .property-id-badge {
      background-color: rgba(255,255,255,0.2);
      color: white;
      padding: 0.25rem 0.75rem;
      border-radius: 50px;
      font-size: 0.85rem;
      font-weight: 500;
      margin-left: 1rem;
    }
    
    @media (max-width: 768px) {
      .form-header {
        padding: 1rem;
      }
      
      .form-title {
        font-size: 1.25rem;
      }
    }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container">
    <a class="navbar-brand" href="admin_propiedades.php">
      <i class="bi bi-arrow-left"></i> Volver
    </a>
    <span class="navbar-text">
      Editando propiedad
    </span>
  </div>
</nav>

<div class="container">
  <form action="guardar_propiedad_edit.php" method="post" enctype="multipart/form-data" class="edit-form p-4">
    <div class="form-header">
      <h2 class="form-title">
        <i class="bi bi-house-gear"></i> Editar propiedad
        <span class="property-id-badge">#<?php echo $p['id']; ?></span>
      </h2>
    </div>
    
    <input type="hidden" name="id" value="<?php echo $p['id']; ?>">
    
    <div class="row g-3 mb-4">
      <div class="col-md-8">
        <label class="form-label">Título de la propiedad</label>
        <input type="text" name="titulo" class="form-control" value="<?php echo htmlspecialchars($p['titulo']); ?>" required>
      </div>
      
      <div class="col-md-4">
        <label class="form-label">Operación</label>
        <select name="operacion" class="form-select">
          <?php foreach(['Comprar','Alquilar'] as $op): ?>
          <option value="<?php echo $op; ?>" <?php if($p['operacion']==$op) echo 'selected'; ?>><?php echo $op; ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    
    <div class="row g-3 mb-4">
      <div class="col-md-4">
        <label class="form-label">Tipo de propiedad</label>
        <select name="tipo" class="form-select" required>
          <option value="Casa" <?php if($p['tipo']=='Casa') echo 'selected'; ?>>Casa</option>
          <option value="Departamento" <?php if($p['tipo']=='Departamento') echo 'selected'; ?>>Departamento</option>
          <option value="PH" <?php if($p['tipo']=='PH') echo 'selected'; ?>>PH</option>
          <option value="Lote" <?php if($p['tipo']=='Lote') echo 'selected'; ?>>Lote</option>
          <option value="Galpón" <?php if($p['tipo']=='Galpón') echo 'selected'; ?>>Galpón</option>
          <option value="Garage" <?php if($p['tipo']=='Garage') echo 'selected'; ?>>Garage</option>
          <option value="Oficina" <?php if($p['tipo']=='Oficina') echo 'selected'; ?>>Oficina</option>
        </select>
      </div>
      
      <div class="col-md-4">
        <label class="form-label">Precio ($)</label>
        <div class="input-group">
          <span class="input-group-text">$</span>
          <input type="number" name="precio" class="form-control" step="0.01" value="<?php echo $p['precio']; ?>" required>
        </div>
      </div>
      
      <div class="col-md-2">
        <label class="form-label">Ambientes</label>
        <input type="number" name="ambientes" class="form-control" min="1" value="<?php echo $p['ambientes'] ?? 1; ?>">
      </div>
      
      <div class="col-md-2">
        <label class="form-label">Baños</label>
        <input type="number" name="banos" class="form-control" min="1" value="<?php echo $p['banos'] ?? 1; ?>">
      </div>
    </div>
    
    <div class="row g-3 mb-4">
      <div class="col-md-6">
        <label class="form-label">Localidad</label>
        <input type="text" name="localidad" class="form-control" value="<?php echo $p['localidad']; ?>">
      </div>
      
      <div class="col-md-6">
        <label class="form-label">Barrio</label>
        <input type="text" name="barrio" class="form-control" value="<?php echo $p['barrio']; ?>">
      </div>
    </div>
    
    <div class="mb-4">
      <label class="form-label">Descripción detallada</label>
      <textarea name="descripcion" rows="6" class="form-control"><?php echo htmlspecialchars($p['descripcion']); ?></textarea>
    </div>
    
    <div class="mb-4">
      <label class="form-label">Imagen principal</label>
      <input type="file" name="imagen" class="form-control" accept="image/*">
      <?php if (!empty($p['imagen'])): ?>
        <div class="mt-2">
          <small class="text-muted">Imagen actual:</small>
          <div class="fw-semibold"><?php echo $p['imagen']; ?></div>
        </div>
      <?php endif; ?>
    </div>
    
    <div class="d-flex justify-content-between pt-3 border-top">
      <a href="admin_propiedades.php" class="btn btn-outline-secondary btn-cancel">
        <i class="bi bi-x-lg"></i> Cancelar
      </a>
      <button class="btn btn-success btn-save" type="submit">
        <i class="bi bi-check-lg"></i> Guardar cambios
      </button>
    </div>
  </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>