<?php
session_start();
if (isset($_SESSION['admin'])) {
  header("Location: dashboard.php");
  exit;
}

// --- Configuración ---
// Usuario y contraseña hardcoded (cámbialos):
$USER = 'admin';
$PASS_HASH = password_hash('1234', PASSWORD_DEFAULT); // cambiá '1234'

// ---------------------
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = $_POST['usuario'] ?? '';
  $p = $_POST['password'] ?? '';
  if ($u === $USER && password_verify($p, $PASS_HASH)) {
    $_SESSION['admin'] = $u;
    header("Location: dashboard.php");
    exit;
  } else {
    $error = 'Usuario o contraseña incorrectos';
  }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <style>
    body {
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
      background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .login-card {
      width: 380px;
      border-radius: 12px;
      overflow: hidden;
      border: none;
      transition: transform 0.3s ease;
    }
    .login-card:hover {
      transform: translateY(-5px);
    }
    .card-header {
      background: #0d6efd;
      color: white;
      text-align: center;
      padding: 20px;
      font-weight: 600;
      font-size: 1.5rem;
    }
    .card-body {
      padding: 30px;
    }
    .form-control {
      border-radius: 8px;
      padding: 10px 15px;
      border: 1px solid #ced4da;
    }
    .form-control:focus {
      border-color: #86b7fe;
      box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }
    .btn-login {
      background: #0d6efd;
      border: none;
      border-radius: 8px;
      padding: 10px;
      font-weight: 500;
      letter-spacing: 0.5px;
      transition: all 0.3s ease;
    }
    .btn-login:hover {
      background: #0b5ed7;
      transform: translateY(-2px);
    }
    .input-icon {
      position: relative;
    }
    .input-icon i {
      position: absolute;
      left: 15px;
      top: 12px;
      color: #6c757d;
    }
    .input-icon input {
      padding-left: 40px;
    }
  </style>
</head>
<body>
  <div class="card login-card shadow-lg">
    <div class="card-header">
      <i class="bi bi-shield-lock me-2"></i>Panel Administrativo
    </div>
    <div class="card-body">
      <?php if ($error): ?>
        <div class="alert alert-danger d-flex align-items-center">
          <i class="bi bi-exclamation-triangle-fill me-2"></i>
          <div><?php echo $error; ?></div>
        </div>
      <?php endif; ?>
      <form method="post">
        <div class="mb-4 input-icon">
          <label class="form-label fw-medium">Usuario</label>
          <i class="bi bi-person-fill"></i>
          <input type="text" name="usuario" class="form-control" placeholder="Ingrese su usuario" required>
        </div>
        <div class="mb-4 input-icon">
          <label class="form-label fw-medium">Contraseña</label>
          <i class="bi bi-key-fill"></i>
          <input type="password" name="password" class="form-control" placeholder="Ingrese su contraseña" required>
        </div>
        <button class="btn btn-primary w-100 btn-login py-2" type="submit">
          <i class="bi bi-box-arrow-in-right me-2"></i>Ingresar
        </button>
      </form>
    </div>
  </div>
  
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>