<?php
// admin/destacados.php
session_start();
require '../conexion.php';
// TODO: validar que sea admin

mysqli_report(MYSQLI_REPORT_OFF); // evitamos warnings automáticos

$ok = $err = '';

// Guardar cambios
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $seleccionados = isset($_POST['destacados']) ? array_map('intval', $_POST['destacados']) : [];
  $ordenes = isset($_POST['orden']) ? $_POST['orden'] : [];

  // Transacción para consistencia
  $conn->begin_transaction();
  try {
    // 1) Si no hay ninguno marcado: borramos todos los destacados
    if (empty($seleccionados)) {
      if (!$conn->query("DELETE FROM propiedades_destacadas")) {
        throw new Exception("DELETE all failed: " . $conn->error);
      }
    } else {
      // 2) Borramos los que ya no están seleccionados
      //    armamos un IN seguro
      $in = implode(',', array_fill(0, count($seleccionados), '?'));
      $types = str_repeat('i', count($seleccionados));
      $sqlDel = "DELETE FROM propiedades_destacadas WHERE propiedad_id NOT IN ($in)";
      $stmtDel = $conn->prepare($sqlDel);
      $stmtDel->bind_param($types, ...$seleccionados);
      if (!$stmtDel->execute()) {
        throw new Exception("DELETE NOT IN failed: " . $stmtDel->error);
      }
      $stmtDel->close();

      // 3) UPSERT de los seleccionados (requiere UNIQUE en propiedad_id)
      //    Si tu MySQL es 5.7/8.0 va perfecto:
      $stmtUp = $conn->prepare("
        INSERT INTO propiedades_destacadas (propiedad_id, orden, activo)
        VALUES (?, ?, 1)
        ON DUPLICATE KEY UPDATE orden = VALUES(orden), activo = 1
      ");
      foreach ($seleccionados as $pid) {
        $ord = (isset($ordenes[$pid]) && is_numeric($ordenes[$pid])) ? (int)$ordenes[$pid] : 1;
        $stmtUp->bind_param("ii", $pid, $ord);
        if (!$stmtUp->execute()) {
          throw new Exception("UPSERT failed (propiedad_id=$pid): " . $stmtUp->error);
        }
      }
      $stmtUp->close();
    }

    $conn->commit();
    $ok = "Destacados actualizados.";
  } catch (Exception $e) {
    $conn->rollback();
    $err = "Error al guardar: " . $e->getMessage();
  }
}

// Traer todas las propiedades y cuáles están destacados
$props_res = $conn->query("SELECT id, titulo, tipo, imagen FROM propiedades ORDER BY id DESC");
if (!$props_res) { $err = "Error cargando propiedades: " . $conn->error; }

$destacados = [];
$dest_res  = $conn->query("SELECT propiedad_id, orden FROM propiedades_destacadas WHERE activo=1");
if ($dest_res) {
  while ($d = $dest_res->fetch_assoc()) {
    $destacados[(int)$d['propiedad_id']] = (int)$d['orden'];
  }
} else if (!$err) {
  $err = "Error cargando destacados: " . $conn->error;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Admin · Propiedades destacadas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#f7f9fc; }
    .mini-img { width: 110px; height: 70px; object-fit: cover; border-radius: 8px; }
    .sticky-actions { position: sticky; top: 0; z-index: 10; background: #fff; padding: 12px 0; border-bottom: 1px solid #eee; }
    .table thead th { white-space: nowrap; }
    .w-ord { width: 90px; }
  </style>
</head>
<body>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Propiedades destacadas</h1>
    <a href="../index.php" class="btn btn-outline-secondary btn-sm">↩ Volver al sitio</a>
  </div>

  <?php if ($ok): ?><div class="alert alert-success"><?= htmlspecialchars($ok) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="alert alert-danger"><?= htmlspecialchars($err) ?></div><?php endif; ?>

  <form method="post">
    <div class="sticky-actions d-flex gap-2">
      <button class="btn btn-primary">💾 Guardar destacados</button>
      <button type="button" class="btn btn-outline-secondary" id="btnMarcarNinguno">Quitar todos</button>
    </div>

    <div class="table-responsive mt-3">
      <table class="table align-middle">
        <thead>
          <tr>
            <th>Dest.</th>
            <th>Orden</th>
            <th>Preview</th>
            <th>Título</th>
            <th>Tipo</th>
            <th class="text-end">ID</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($props_res && $props_res->num_rows): ?>
          <?php while($p = $props_res->fetch_assoc()):
            $pid = (int)$p['id'];
            $checked = array_key_exists($pid, $destacados);
            $orden = $checked ? (int)$destacados[$pid] : '';
          ?>
          <tr>
            <td>
              <input type="checkbox" class="form-check-input" name="destacados[]" value="<?= $pid ?>" <?= $checked ? 'checked' : '' ?>>
            </td>
            <td class="w-ord">
              <input type="number" class="form-control form-control-sm" name="orden[<?= $pid ?>]" value="<?= htmlspecialchars($orden) ?>" placeholder="1" min="1">
            </td>
            <td>
              <?php if (!empty($p['imagen'])): ?>
                <img src="../uploads/<?= htmlspecialchars($p['imagen']) ?>" class="mini-img" alt="">
              <?php endif; ?>
            </td>
            <td>
              <div class="fw-semibold"><?= htmlspecialchars($p['titulo']) ?></div>
              <a href="../propiedad.php?id=<?= $pid ?>" target="_blank" class="small text-decoration-none">ver</a>
            </td>
            <td><?= htmlspecialchars($p['tipo']) ?></td>
            <td class="text-end text-muted"><?= $pid ?></td>
          </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="6" class="text-muted">No hay propiedades cargadas.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="mt-3">
      <button class="btn btn-primary">💾 Guardar destacados</button>
    </div>
  </form>
</div>

<script>
document.getElementById('btnMarcarNinguno').addEventListener('click', ()=>{
  document.querySelectorAll('input[name="destacados[]"]').forEach(ch => ch.checked = false);
});
</script>
</body>
</html>
