<?php
session_start();
if (!isset($_SESSION['admin'])) { header('Location: login.php'); exit; }

require '../conexion.php';

// Conteos rápidos
$tot_prop = $conn->query("SELECT COUNT(*) as c FROM propiedades")->fetch_assoc()['c'];
$tot_cons = $conn->query("SELECT COUNT(*) as c FROM consultas")->fetch_assoc()['c'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard Admin | Inmobiliaria</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <style>
    :root {
      --primary-color: #2c3e50;
      --secondary-color: #3498db;
      --accent-color: #e74c3c;
      --success-color: #27ae60;
      --light-bg: #f8f9fa;
      --dark-text: #2c3e50;
      --light-text: #7f8c8d;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      color: var(--dark-text);
      line-height: 1.6;
      background-color: #f5f7fa;
    }
    
    .navbar {
      background-color: var(--primary-color) !important;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .navbar-brand {
      font-weight: 700;
      font-size: 1.3rem;
      display: flex;
      align-items: center;
    }
    
    .dashboard-card {
      border: none;
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 4px 15px rgba(0,0,0,0.08);
      transition: all 0.3s ease;
      height: 100%;
    }
    
    .dashboard-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 25px rgba(0,0,0,0.12);
    }
    
    .card-properties {
      border-left: 4px solid var(--secondary-color);
    }
    
    .card-consultas {
      border-left: 4px solid var(--success-color);
    }
    
    .card-icon {
      font-size: 2.5rem;
      margin-bottom: 1rem;
      opacity: 0.8;
    }
    
    .card-count {
      font-weight: 700;
      margin: 0.5rem 0;
    }
    
    .btn-logout {
      border-color: rgba(255,255,255,0.2);
      transition: all 0.3s;
    }
    
    .btn-logout:hover {
      background-color: rgba(255,255,255,0.1);
      border-color: rgba(255,255,255,0.3);
    }
    
    .admin-header {
      margin-bottom: 2rem;
      padding-bottom: 1rem;
      border-bottom: 1px solid #eee;
    }
    
    .quick-actions {
      margin-top: 2rem;
    }
    
    .quick-action-item {
      display: flex;
      align-items: center;
      padding: 1rem;
      border-radius: 8px;
      background-color: white;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
      transition: all 0.3s;
      margin-bottom: 1rem;
    }
    
    .quick-action-item:hover {
      transform: translateX(5px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .quick-action-icon {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 1rem;
      font-size: 1.2rem;
      color: white;
    }
    
    @media (max-width: 768px) {
      .dashboard-card {
        margin-bottom: 1.5rem;
      }
    }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container">
    <span class="navbar-brand">
      <i class="bi bi-speedometer2 me-2"></i> Panel de Administración
    </span>
    <a href="logout.php" class="btn btn-outline-light btn-sm btn-logout">
      <i class="bi bi-box-arrow-right"></i> Cerrar Sesión
    </a>
     <div class="ms-auto">
      <a href="../index.php" class="btn btn-outline-light">
        <i class="bi bi-arrow-left"></i> Ir al sitio web.
      </a>
  </div>
  
</nav>

<div class="container">
  <div class="admin-header">
    <h2 class="mb-3"><i class="bi bi-house-gear me-2"></i> Resumen General</h2>
    <p class="text-muted">Bienvenido al panel de administración de la inmobiliaria</p>
  </div>
  
  <div class="row g-4">
    <div class="col-md-6 col-lg-4">
      <div class="dashboard-card card-properties">
        <div class="card-body text-center p-4">
          <div class="card-icon text-primary">
            <i class="bi bi-house"></i>
          </div>
          <h3 class="card-count display-5"><?php echo $tot_prop; ?></h3>
          <p class="lead">Propiedades publicadas</p>
          <a href="admin_propiedades.php" class="btn btn-primary w-100">
            <i class="bi bi-gear me-1"></i> Gestionar
          </a>
        </div>
      </div>
    </div>
    
    <div class="col-md-6 col-lg-4">
      <div class="dashboard-card card-consultas">
        <div class="card-body text-center p-4">
          <div class="card-icon text-success">
            <i class="bi bi-envelope"></i>
          </div>
          <h3 class="card-count display-5"><?php echo $tot_cons; ?></h3>
          <p class="lead">Consultas recibidas</p>
          <a href="ver_consultas.php" class="btn btn-success w-100">
            <i class="bi bi-eye me-1"></i> Ver consultas
          </a>
        </div>
      </div>
    </div>
    
    <div class="col-md-6 col-lg-4">
      <div class="dashboard-card">
        <div class="card-body text-center p-4">
          <div class="card-icon" style="color: var(--accent-color);">
            <i class="bi bi-plus-circle"></i>
          </div>
          <h3 class="card-count display-5">+</h3>
          <p class="lead">Agregar nueva propiedad</p>
          <a href="cargar.php" class="btn btn-outline-primary w-100">
            <i class="bi bi-plus-lg me-1"></i> Crear
          </a>
        </div>
      </div>
    </div>
  </div>
  
  <div class="quick-actions">
    <h4 class="mb-3"><i class="bi bi-lightning me-2"></i> Acciones rápidas</h4>
    <div class="row">
      <div class="col-md-6">
     <a href="destacados.php" class="text-decoration-none">
          <div class="quick-action-item">
            <div class="quick-action-icon" style="background-color: var(--secondary-color);">
              <i class="bi bi-cash-stack"></i>
            </div>
            <div>
              <h6 class="mb-0">Cambiar imagenes de propiedades destacadas</h6>
              <small class="text-muted">Ver y gestionar</small>
            </div>
          </div>
        </a>
      </div>
      
        <!--   <div class="col-md-6">
        <a href="admin_propiedades.php?filter=comprar" class="text-decoration-none">
          <div class="quick-action-item">
            <div class="quick-action-icon" style="background-color: var(--success-color);">
              <i class="bi bi-currency-dollar"></i>
            </div>
            <div>
              <h6 class="mb-0">Propiedades en venta</h6>
              <small class="text-muted">Ver y gestionar</small>
            </div>
          </div>
        </a>
      </div>-->
      
      <div class="col-md-6">
    <a href="admin_usuarios.php" class="text-decoration-none">
      <div class="quick-action-item">
        <div class="quick-action-icon" style="background-color: var(--accent-color);">
          <i class="bi bi-person-plus"></i>
        </div>
        <div>
          <h6 class="mb-0">Agregar un Administrador</h6>
          <small class="text-muted">Crear un nuevo usuario</small>
        </div>
      </div>
    </a>
  </div>

      
  <!--    <div class="col-md-6">
        <a href="configuracion.php" class="text-decoration-none">
          <div class="quick-action-item">
            <div class="quick-action-icon" style="background-color: #9b59b6;">
              <i class="bi bi-sliders"></i>
            </div>
            <div>
              <h6 class="mb-0">Configuración</h6>
              <small class="text-muted">Ajustes del sistema</small>-->
            </div>
          </div>
        </a>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>