<?php
session_start();
if (!isset($_SESSION['admin'])) { header('Location: login.php'); exit; }

require '../conexion.php';

// ----- Crear nuevo usuario -----
$mensaje = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $usuario = trim($_POST['usuario'] ?? '');
  $password = $_POST['password'] ?? '';
  $nombre   = trim($_POST['nombre'] ?? '');
  $email    = trim($_POST['email'] ?? '');

  if ($usuario && $password) {
    // ¿existe?
    $ex = $conn->prepare("SELECT id FROM admin_users WHERE usuario = ?");
    $ex->bind_param("s", $usuario);
    $ex->execute();
    $ex->store_result();
    if ($ex->num_rows > 0) {
      $mensaje = '<div class="alert alert-warning">Ese usuario ya existe.</div>';
    } else {
      $hash = password_hash($password, PASSWORD_DEFAULT);
      $stmt = $conn->prepare("INSERT INTO admin_users (usuario, password, nombre, email, fecha) VALUES (?,?,?,?,NOW())");
      $stmt->bind_param("ssss", $usuario, $hash, $nombre, $email);
      $stmt->execute();
      $stmt->close();
      $mensaje = '<div class="alert alert-success">Usuario creado correctamente.</div>';
    }
    $ex->close();
  } else {
    $mensaje = '<div class="alert alert-danger">Usuario y contraseña son obligatorios.</div>';
  }
}

// ----- Borrar usuario -----
if (isset($_GET['del'])) {
  $del_id = (int)$_GET['del'];
  if ($del_id === 1) { // proteger superadmin id 1
    $mensaje = '<div class="alert alert-danger">No se puede borrar el superadmin.</div>';
  } else {
    $del = $conn->prepare("DELETE FROM admin_users WHERE id = ?");
    $del->bind_param("i", $del_id);
    $del->execute();
    $del->close();
    $mensaje = '<div class="alert alert-info">Usuario eliminado.</div>';
  }
}

// ----- Traer lista de usuarios -----
$lista = $conn->query("SELECT id, usuario, nombre, email, fecha FROM admin_users ORDER BY id ASC");
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Administrar usuarios admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">← Dashboard</a>
    <span class="navbar-text text-white">Usuarios admin</span>
  </div>
</nav>

<div class="container">
  <?php echo $mensaje; ?>

  <div class="card mb-4">
    <div class="card-header bg-primary text-white">Crear nuevo usuario</div>
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-md-3">
          <label class="form-label">Usuario *</label>
          <input type="text" name="usuario" class="form-control" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Contraseña *</label>
          <input type="password" name="password" class="form-control" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">Nombre</label>
          <input type="text" name="nombre" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Email</label>
          <input type="email" name="email" class="form-control">
        </div>
        <div class="col-12">
          <button class="btn btn-success">Crear</button>
        </div>
      </form>
    </div>
  </div>

  <h4>Usuarios existentes</h4>
  <div class="table-responsive">
    <table class="table table-hover align-middle">
      <thead class="table-dark">
        <tr>
          <th>ID</th><th>Usuario</th><th>Nombre</th><th>Email</th><th>Desde</th><th>Acciones</th>
        </tr>
      </thead>
      <tbody>
      <?php while($u = $lista->fetch_assoc()): ?>
        <tr>
          <td><?php echo $u['id']; ?></td>
          <td><?php echo htmlspecialchars($u['usuario']); ?></td>
          <td><?php echo htmlspecialchars($u['nombre']); ?></td>
          <td><?php echo htmlspecialchars($u['email']); ?></td>
          <td><?php echo date('d/m/Y', strtotime($u['fecha'])); ?></td>
          <td>
            <?php if ($u['id'] != 1): ?>
              <a href="?del=<?php echo $u['id']; ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('¿Borrar usuario?');">Eliminar</a>
            <?php else: ?>
              —
            <?php endif; ?>
          </td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
