<?php
session_start();
// Simple auth check (replace with real auth)
if (!isset($_SESSION['admin'])) {
  header('Location: login.php');
  exit;
}

require '../conexion.php';

// Opcional: búsqueda por título
$busqueda = $_GET['q'] ?? '';

$sql = "SELECT * FROM propiedades";
$params = [];
$types  = '';

if ($busqueda !== '') {
  $sql .= " WHERE titulo LIKE ?";
  $params[] = '%' . $busqueda . '%';
  $types .= 's';
}

$sql .= " ORDER BY id DESC";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
  $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$res = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin • Propiedades | Inmobiliaria</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <style>
    :root {
      --primary-color: #2c3e50;
      --secondary-color: #3498db;
      --accent-color: #e74c3c;
      --light-bg: #f8f9fa;
      --dark-text: #2c3e50;
      --light-text: #7f8c8d;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      color: var(--dark-text);
      background-color: #f5f7fa;
    }
    
    .navbar {
      background-color: var(--primary-color) !important;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .navbar-brand {
      font-weight: 700;
      display: flex;
      align-items: center;
    }
    
    .navbar-text {
      font-size: 1rem;
      opacity: 0.8;
    }
    
    .admin-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 2rem;
      padding-bottom: 1rem;
      border-bottom: 1px solid #eee;
    }
    
    .search-box {
      max-width: 400px;
    }
    
    .btn-new {
      background-color: var(--secondary-color);
      border-color: var(--secondary-color);
      font-weight: 500;
      transition: all 0.3s;
    }
    
    .btn-new:hover {
      background-color: #2980b9;
      border-color: #2980b9;
      transform: translateY(-2px);
    }
    
    .table-responsive {
      border-radius: 8px;
      overflow: hidden;
      box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    
    .table {
      margin-bottom: 0;
    }
    
    .table thead {
      background-color: var(--primary-color);
      color: white;
    }
    
    .table th {
      font-weight: 600;
      padding: 1rem;
    }
    
    .table td {
      padding: 0.75rem 1rem;
      vertical-align: middle;
    }
    
    .table-hover tbody tr:hover {
      background-color: rgba(52, 152, 219, 0.05);
    }
    
    .badge-operation {
      padding: 0.35rem 0.6rem;
      font-weight: 500;
      border-radius: 4px;
    }
    
    .badge-venta {
      background-color: #d4edda;
      color: #155724;
    }
    
    .badge-alquiler {
      background-color: #e2e3e5;
      color: #383d41;
    }
    
    .price-cell {
      font-weight: 600;
      color: var(--accent-color);
    }
    
    .action-buttons {
      display: flex;
      gap: 0.5rem;
    }
    
    .no-results {
      text-align: center;
      padding: 3rem;
      background-color: white;
      border-radius: 8px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    
    .no-results-icon {
      font-size: 3rem;
      color: var(--light-text);
      margin-bottom: 1rem;
    }
    
    @media (max-width: 768px) {
      .admin-header {
        flex-direction: column;
        gap: 1rem;
        align-items: flex-start;
      }
      
      .search-box {
        width: 100%;
      }
    }
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container">
    <a class="navbar-brand" href="dashboard.php">
      <i class="bi bi-speedometer2 me-2"></i> Panel Admin
    </a>
    <span class="navbar-text">
      <i class="bi bi-chevron-right"></i> Propiedades
    </span>
  </div>
</nav>

<div class="container">
  <div class="admin-header">
    <h2><i class="bi bi-house-gear me-2"></i> Gestión de Propiedades</h2>
    <a href="cargar.php" class="btn btn-new">
      <i class="bi bi-plus-lg"></i> Nueva propiedad
    </a>
  </div>
  
  <form class="d-flex search-box mb-4" method="get">
    <div class="input-group">
      <input class="form-control" type="search" name="q" placeholder="Buscar propiedades..." value="<?php echo htmlspecialchars($busqueda); ?>">
      <button class="btn btn-outline-secondary" type="submit">
        <i class="bi bi-search"></i>
      </button>
    </div>
  </form>

  <?php if ($res->num_rows === 0): ?>
    <div class="no-results">
      <div class="no-results-icon">
        <i class="bi bi-house-x"></i>
      </div>
      <h4>No se encontraron propiedades</h4>
      <p class="text-muted"><?php echo $busqueda ? 'Intenta con otro término de búsqueda' : 'No hay propiedades registradas aún'; ?></p>
      <a href="cargar.php" class="btn btn-primary mt-3">
        <i class="bi bi-plus-lg"></i> Agregar primera propiedad
      </a>
    </div>
  <?php else: ?>
    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>ID</th>
            <th>Título</th>
            <th>Tipo</th>
            <th>Operación</th>
            <th>Precio</th>
            <th>Ubicación</th>
            <th>Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php while ($p = $res->fetch_assoc()): ?>
          <tr>
            <td><?php echo $p['id']; ?></td>
            <td>
              <strong><?php echo htmlspecialchars($p['titulo']); ?></strong>
              <div class="text-muted small"><?php echo $p['ambientes']; ?> amb.</div>
            </td>
            <td><?php echo $p['tipo']; ?></td>
            <td>
              <span class="badge badge-operation <?php echo $p['operacion'] === 'Alquilar' ? 'badge-alquiler' : 'badge-venta'; ?>">
                <?php echo $p['operacion']; ?>
              </span>
            </td>
            <td class="price-cell">$<?php echo number_format($p['precio'],0,',','.'); ?></td>
            <td>
              <div><?php echo $p['barrio']; ?></div>
              <div class="text-muted small"><?php echo $p['localidad']; ?></div>
            </td>
            <td>
              <div class="action-buttons">
                <a href="editar_propiedad.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-outline-primary" title="Editar">
                  <i class="bi bi-pencil"></i>
                </a>
                <a href="eliminar_propiedad.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-outline-danger" title="Eliminar" onclick="return confirm('¿Estás seguro de eliminar esta propiedad?');">
                  <i class="bi bi-trash"></i>
                </a>
              </div>
            </td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>