<?php
// ajax/guardar_comentario.php
// Guarda un nuevo comentario enviado por fetch (JSON).

header('Content-Type: application/json');

require_once __DIR__ . '/../conexion.php';

$payload = json_decode(file_get_contents('php://input'), true);

$mesa_id = isset($payload['mesa_id']) ? intval($payload['mesa_id']) : 0;
$texto   = isset($payload['texto'])   ? trim($payload['texto'])   : '';

if ($mesa_id <= 0 || $texto === '') {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'Datos inválidos']);
    exit;
}

$stmt = mysqli_prepare($con, "INSERT INTO comentarios_mesa (mesa_id, texto, fecha) VALUES (?, ?, NOW())");
mysqli_stmt_bind_param($stmt, "is", $mesa_id, $texto);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['ok' => true]);
} else {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => mysqli_error($con)]);
}
