<?php
require '../conexion.php';

$mesa_id = $_POST['mesa_id'] ?? null;
$cliente = $_POST['cliente'] ?? '';
$comentario = $_POST['comentario'] ?? '';
$total = floatval($_POST['total'] ?? 0);
$efectivo = floatval($_POST['efectivo'] ?? 0);
$transferencia = floatval($_POST['transferencia'] ?? 0);
$forma_pago = $_POST['forma_pago'] ?? '';
$descuento = floatval($_POST['descuento'] ?? 0);
$productos_json = $_POST['productos_json'] ?? '[]';

$productos = json_decode($productos_json, true);

// 1. Insertar encabezado en tickets_mesa
$query = "INSERT INTO tickets_mesa (mesa_id, cliente, comentario, total, efectivo, transferencia, forma_pago, descuento, fecha)
          VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())";
$stmt = $con->prepare($query);
$stmt->bind_param("issdddss", $mesa_id, $cliente, $comentario, $total, $efectivo, $transferencia, $forma_pago, $descuento);
$stmt->execute();

$ticket_id = $stmt->insert_id;

// 2. Insertar cada producto en tickets_mesa_detalle
foreach ($productos as $p) {
    $producto_id = intval($p['id'] ?? 0);
    $precio = floatval($p['precio'] ?? 0);
    if ($producto_id > 0) {
        $stmt2 = $con->prepare("INSERT INTO tickets_mesa_detalle (ticket_id, producto_id, precio) VALUES (?, ?, ?)");
        $stmt2->bind_param("iid", $ticket_id, $producto_id, $precio);
        $stmt2->execute();
    }
}

// 3. Respuesta
echo json_encode(['success' => true, 'ticket_id' => $ticket_id]);
