<?php
/**
 * truncate_tables.php
 * Vacía tablas críticas del sistema de bar/salas.
 * USO:
 *   - Colocar este archivo en la carpeta /admin (o donde prefieras)
 *   - Acceder vía navegador o cURL: http://tu-sitio/admin/truncate_tables.php
 *   - Requiere que 'conexion.php' devuelva $con = mysqli_connect(...)
 *   - Responde JSON: { ok: true, msg: "..."} o { ok: false, error: "..." }
 */
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
header('Content-Type: application/json; charset=utf-8');

// Ajustá la ruta a tu archivo de conexión si es distinto
require_once __DIR__ . '/../conexion.php';

try {
    // Deshabilitar claves foráneas temporalmente
    $con->query("SET FOREIGN_KEY_CHECKS = 0");
    $con->begin_transaction();

    // Listado de tablas a vaciar
    $tables = [
        'comandas_cocina',
        'tickets_mesa',
        'tickets_mesa_detalle',
        'caja_mesa'
    ];

    foreach ($tables as $tbl) {
        $con->query("TRUNCATE TABLE `$tbl`");
    }

    $con->query("SET FOREIGN_KEY_CHECKS = 1");
    $con->commit();

    echo json_encode(['ok' => true, 'msg' => 'Tablas truncadas correctamente']);

} catch (Exception $e) {
    $con->rollback();
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]);
}
?>
