<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require '../conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');

$desde = $_GET['desde'] ?? date('Y-m-01');
$hasta = $_GET['hasta'] ?? date('Y-m-d');

/**
 * Devuelve:
 *  - array de movimientos
 *  - total en efectivo
 *  - total en transferencia
 */
function obtenerCaja($con, $tabla) {
  global $desde, $hasta;
  $sql = "SELECT * FROM {$tabla}
          WHERE fecha BETWEEN '$desde' AND '$hasta'
          ORDER BY fecha DESC, hora DESC";
  $res = mysqli_query($con, $sql);

  $datos = [];
  $total_efectivo = 0;
  $total_transferencia = 0;

  while ($row = mysqli_fetch_assoc($res)) {
    $datos[] = $row;
    $total_efectivo     += floatval($row['efectivo']);
    $total_transferencia += floatval($row['transferencia']);
  }
  return [$datos, $total_efectivo, $total_transferencia];
}

list($caja_mesa, $total_efectivo_mesa, $total_transferencia_mesa) = obtenerCaja($con, 'caja_mesa');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Administrar Caja Mesas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
</head>
<body class="p-4">
  <div class="container">
    <h2 class="mb-4">💵 Caja Mesas</h2>

    <!-- Filtro por fecha -->
    <form method="get" class="row g-3 mb-4">
      <div class="col-auto">
        <label>Desde</label>
        <input type="date" name="desde" class="form-control" value="<?= htmlspecialchars($desde) ?>">
      </div>
      <div class="col-auto">
        <label>Hasta</label>
        <input type="date" name="hasta" class="form-control" value="<?= htmlspecialchars($hasta) ?>">
      </div>
      <div class="col-auto mt-4">
        <button type="submit" class="btn btn-primary">Filtrar</button>
      </div>
    </form>

    <!-- Totales -->
    <h5>Totales Mesas</h5>
    <p>Efectivo: <strong>$<?= number_format($total_efectivo_mesa, 2) ?></strong></p>
    <p>Transferencia: <strong>$<?= number_format($total_transferencia_mesa, 2) ?></strong></p>
    <p>Total: <strong>$<?= number_format($total_efectivo_mesa + $total_transferencia_mesa, 2) ?></strong></p>

    <!-- Acciones -->
    <div class="mb-3">
      <button class="btn btn-success me-2" onclick="abrirModal('mesa')">➕ Ingreso/Egreso Mesa</button>
      <button class="btn btn-danger" onclick="reiniciarCaja('mesa')">🔄 Reiniciar Caja Mesa</button>
    </div>

    <!-- Movimientos -->
    <div class="accordion" id="acordeonMesa">
      <?php foreach ($caja_mesa as $i => $mov): ?>
      <?php
        $importe = floatval($mov['efectivo']) + floatval($mov['transferencia']);
      ?>
      <div class="accordion-item">
        <h2 class="accordion-header" id="headingMesa<?= $i ?>">
          <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseMesa<?= $i ?>">
            <?= $mov['fecha'] ?> <?= $mov['hora'] ?> - $<?= number_format($importe, 2) ?> (<?= $mov['forma_pago'] ?>)
          </button>
        </h2>
        <div id="collapseMesa<?= $i ?>" class="accordion-collapse collapse" data-bs-parent="#acordeonMesa">
          <div class="accordion-body">
            <?php if (!empty($mov['comentario'])): ?>
              <p><strong>Comentario:</strong> <?= nl2br(htmlspecialchars($mov['comentario'])) ?></p>
            <?php endif; ?>

            <?php if (!empty($mov['ticket_html'])): ?>
              <div class="border p-2"><?= $mov['ticket_html'] ?></div>
              <a href="../ver_ticket_mesa.php?id=<?= $mov['id'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary mt-2">Ver ticket completo</a>
            <?php else: ?>
              <a href="../ver_ticket_mesa.php?id=<?= $mov['id'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary mt-2">Ver ticket completo</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Modal Movimiento Manual -->
  <div class="modal fade" id="modalMovimiento" tabindex="-1">
    <div class="modal-dialog">
      <form method="post" action="guardar_movimiento_manual.php" class="modal-content">
        <input type="hidden" name="origen" id="inputOrigen" value="mesa">
        <div class="modal-header"><h5 class="modal-title">➕ Movimiento Manual</h5></div>
        <div class="modal-body">
          <label>Monto</label>
          <input type="number" name="monto" class="form-control mb-2" step="0.01" required>
          <label>Tipo</label>
          <select name="tipo" class="form-select mb-2">
            <option value="ingreso">Ingreso</option>
            <option value="egreso">Egreso</option>
          </select>
          <label>Forma de pago</label>
          <select name="forma_pago" class="form-select mb-2">
            <option value="efectivo">Efectivo</option>
            <option value="transferencia">Transferencia</option>
          </select>
          <label>Comentario</label>
          <textarea name="comentario" class="form-control" rows="2"></textarea>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Guardar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>

  <script>
  function abrirModal(origen) {
    document.getElementById('inputOrigen').value = origen;
    new bootstrap.Modal(document.getElementById('modalMovimiento')).show();
  }

  function reiniciarCaja(origen) {
    if (confirm('¿Seguro que querés reiniciar la caja de ' + origen + '?\nEsto agregará un ajuste negativo pero no borra los tickets.')) {
      fetch('reiniciar_caja.php?origen=' + origen, { method: 'POST' })
        .then(r => r.text())
        .then(txt => {
          alert('Caja reiniciada correctamente');
          location.reload();
        });
    }
  }
  </script>
</body>
</html>
