<?php
require_once 'conexion.php';

// --- Productos disponibles para mesas ---
$productos_mesas = mysqli_fetch_all(
    mysqli_query($con, "SELECT id, nombre, precio, stock FROM productos_mesas WHERE visible = 1 ORDER BY nombre ASC"),
    MYSQLI_ASSOC
);
$mesa_id = 3; // Mesa fija nº1
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Mesa 3</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
  .ticket-box div { font-size: .9rem; }
  .lista-productos-mesa li { cursor: pointer; }
  body {
    background-color: #f8f9fa;
    font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
  }
  
  .card {
    max-width: 420px;
    border-radius: 12px;
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
    border: none;
    overflow: hidden;
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
  }
  
  .card h4 {
    color: #2c3e50;
    font-weight: 600;
    border-bottom: 2px solid #e9ecef;
    padding-bottom: 12px;
    margin-bottom: 20px;
    position: relative;
  }
  
  .card h4:after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 60px;
    height: 2px;
    background: #3498db;
  }
  
  .form-control, .form-select {
    border-radius: 8px;
    padding: 10px 15px;
    border: 1px solid #dfe6e9;
    transition: all 0.3s ease;
    box-shadow: none;
  }
  
  .form-control:focus, .form-select:focus {
    border-color: #3498db;
    box-shadow: 0 0 0 0.25rem rgba(52, 152, 219, 0.25);
  }
  
  label {
    font-weight: 500;
    color: #495057;
    margin-bottom: 6px;
    display: block;
  }
  
  .lista-productos-mesa {
    max-height: 200px;
    overflow-y: auto;
    border-radius: 8px;
    margin-top: 8px;
  }
  
  .lista-productos-mesa li {
    transition: all 0.2s ease;
    border-radius: 6px !important;
    margin-bottom: 4px;
    border: 1px solid #e9ecef !important;
  }
  
  .lista-productos-mesa li:hover {
    background-color: #f8f9fa;
    transform: translateX(2px);
  }
  
  .badge.bg-danger {
    background-color: #e74c3c !important;
    border-radius: 50%;
    width: 22px;
    height: 22px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.2s ease;
  }
  
  .badge.bg-danger:hover {
    transform: scale(1.1);
  }
  
  .ticket-box {
    background-color: #f8f9fa;
    border-radius: 10px;
    border: 1px dashed #dee2e6;
    padding: 15px;
    margin-top: 15px;
    transition: all 0.3s ease;
  }
  
  .ticket-box:hover {
    border-color: #3498db;
    box-shadow: 0 2px 8px rgba(52, 152, 219, 0.1);
  }
  
  .ticket-box div {
    font-size: 0.9rem;
    margin-bottom: 5px;
    color: #2c3e50;
  }
  
  .ticket-box div:last-child {
    font-weight: 600;
    color: #27ae60;
    font-size: 1rem;
    margin-top: 8px;
    margin-bottom: 0;
  }
  
  .btn-success {
    background-color: #27ae60;
    border: none;
    border-radius: 8px;
    padding: 8px 20px;
    font-weight: 500;
    transition: all 0.3s ease;
  }
  
  .btn-success:hover {
    background-color: #219653;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(39, 174, 96, 0.3);
  }
  
  /* Estilos para el modal */
  .modal-content {
    border-radius: 12px;
    border: none;
  }
  
  .modal-header {
    border-bottom: none;
    padding-bottom: 0;
  }
  
  .modal-body {
    padding-top: 0;
  }
  
  /* Scrollbar personalizada */
  ::-webkit-scrollbar {
    width: 8px;
  }
  
  ::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
  }
  
  ::-webkit-scrollbar-thumb {
    background: #bdc3c7;
    border-radius: 10px;
  }
  
  ::-webkit-scrollbar-thumb:hover {
    background: #95a5a6;
  }
  
  /* Animación sutil al cargar */
  @keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
  }
  
  .card {
    animation: fadeIn 0.4s ease-out forwards;
  }
</style>
</head>
<body style="background-color: #ffcc80;">

<body class="p-3">
  <div class="card p-3 mx-auto" style="max-width: 420px;">
    <form id="form_mesa_<?php echo $mesa_id; ?>">
      <h4 class="mb-3">Mesa <?php echo $mesa_id; ?></h4>

      <div class="mb-2">
        <label>Cliente</label>
        <input type="text" class="form-control" name="cliente">
      </div>

      <div class="mb-2">
        <label>Hora</label>
        <input type="time" class="form-control hora-mesa" name="hora"
               value="<?php echo date('H:i'); ?>" data-mesa="<?php echo $mesa_id; ?>">
      </div>

      <div class="mb-2">
        <label>Productos</label>
        <select class="form-select producto-mesa-select" data-mesa="<?php echo $mesa_id; ?>">
          <option value="">-- Agregar producto --</option>
          <?php foreach ($productos_mesas as $pm): ?>
            <option value="<?php echo $pm['id']; ?>" data-precio="<?php echo $pm['precio']; ?>" data-nombre="<?php echo htmlspecialchars($pm['nombre']); ?>">
              <?php echo htmlspecialchars($pm['nombre']); ?> ($<?php echo number_format($pm['precio'],2,',','.'); ?>)
            </option>
          <?php endforeach; ?>
        </select>
        <ul class="list-group mt-1 lista-productos-mesa" id="productos_mesa_<?php echo $mesa_id; ?>"></ul>
      </div>

      <div class="ticket-box border rounded p-2 mb-2" id="ticket_mesa_<?php echo $mesa_id; ?>">
        Ticket:
        <div>Hora: <span class="ticket-hora"><?php echo date('H:i'); ?></span></div>
        <div>Productos: -</div>
        <div>Total: $0.00</div>
      </div>

      <div class="mt-2 text-end">
        <button type="button" class="btn btn-success btn-sm" onclick="abrirModalCobroMesa(<?php echo $mesa_id; ?>)">
          💰 Cerrar mesa y cobrar
        </button>
      </div>
    </form>
  </div>

<!-- Modal cobro mesa -->
<div class="modal fade" id="modalCobroMesa" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="p-3">
        <form id="formCobroMesa">
          <input type="hidden" name="mesa_id" id="mesa-id">
          <input type="hidden" name="monto" id="mesa-total">

          <h5 class="mb-3">Cobro Mesa</h5>

          <div class="mb-2">
            <label>Total</label>
            <input type="text" class="form-control" id="mesa-total-visible" readonly>
          </div>

          <div class="mb-2">
            <label>Forma de pago</label>
            <select class="form-select" id="mesa-forma-pago" name="forma_pago" required>
              <option value="">-- Seleccionar --</option>
              <option value="efectivo">Efectivo</option>
              <option value="transferencia">Transferencia</option>
              <option value="dividido">Dividido</option>
            </select>
          </div>

          <div class="row mb-2" id="mesa-dividido" style="display:none;">
            <div class="col">
              <label>Efectivo</label>
              <input type="number" step="0.01" class="form-control" id="mesa-efectivo" name="efectivo">
            </div>
            <div class="col">
              <label>Transferencia</label>
              <input type="number" step="0.01" class="form-control" id="mesa-transferencia" name="transferencia">
            </div>
          </div>

          <div class="d-flex justify-content-between mt-3">
            <button type="submit" class="btn btn-success">💾 Confirmar cobro</button>
            <a id="mesa-ver-ticket" href="#" target="_blank" class="btn btn-outline-primary d-none">Ver ticket</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
// ------ LÓGICA DE LA MESA INDIVIDUAL ------
function actualizarTicketMesa(id) {
  let total = 0;
  const lista = $('#productos_mesa_' + id);
  const productosTxt = [];

  lista.find('li').each(function() {
    const precio = parseFloat($(this).data('precio'));
    const nombre = $(this).data('nombre');
    productosTxt.push(nombre + ' ($' + precio.toFixed(2) + ')');
    total += precio;
  });

  const ticketBox = $('#ticket_mesa_' + id);
  ticketBox.find('div:eq(1)').html('Productos: ' + (productosTxt.length ? productosTxt.join(', ') : '-'));
  ticketBox.find('div:eq(2)').html('Total: $' + total.toFixed(2));
}

$(document).on('change', '.producto-mesa-select', function() {
  const mesaId = $(this).data('mesa');
  const select = $(this);
  const productoId = select.val();
  if (!productoId) return;

  const option = select.find('option:selected');
  const nombre = option.data('nombre');
  const precio = parseFloat(option.data('precio'));

  const li = $('<li class="list-group-item d-flex justify-content-between align-items-center"></li>');
  li.text(nombre + ' - $' + precio.toFixed(2));
  li.attr('data-id', productoId).attr('data-precio', precio).attr('data-nombre', nombre);
  $('<span class="badge bg-danger" style="cursor:pointer;">✕</span>').appendTo(li).on('click', function() {
    li.remove();
    actualizarTicketMesa(mesaId);
    saveMesaState(mesaId);
  });

  $('#productos_mesa_' + mesaId).append(li);
  select.val('');
  actualizarTicketMesa(mesaId);
  saveMesaState(mesaId);
});

function abrirModalCobroMesa(id) {
  const ticketTotalTxt = $('#ticket_mesa_' + id + ' div:last-child').text(); // Total: $X
  const total = parseFloat(ticketTotalTxt.replace(/[^0-9.,]/g, '').replace(',', '.')) || 0;

  $('#mesa-id').val(id);
  $('#mesa-total').val(total);
  $('#mesa-total-visible').val('$' + total.toFixed(2));
  $('#mesa-forma-pago').val('');
  $('#mesa-dividido').hide();
  $('#mesa-ver-ticket').addClass('d-none');

  // Resetear el modal a su estado original antes de mostrarlo
  const modalContent = $('#modalCobroMesa .modal-content');
  modalContent.html(`
    <div class="p-3">
      <form id="formCobroMesa">
        <input type="hidden" name="mesa_id" id="mesa-id" value="${id}">
        <input type="hidden" name="monto" id="mesa-total" value="${total}">

        <h5 class="mb-3">Cobro Mesa</h5>

        <div class="mb-2">
          <label>Total</label>
          <input type="text" class="form-control" id="mesa-total-visible" value="$${total.toFixed(2)}" readonly>
        </div>

        <div class="mb-2">
          <label>Forma de pago</label>
          <select class="form-select" id="mesa-forma-pago" name="forma_pago" required>
            <option value="">-- Seleccionar --</option>
            <option value="efectivo">Efectivo</option>
            <option value="transferencia">Transferencia</option>
            <option value="dividido">Dividido</option>
          </select>
        </div>

        <div class="row mb-2" id="mesa-dividido" style="display:none;">
          <div class="col">
            <label>Efectivo</label>
            <input type="number" step="0.01" class="form-control" id="mesa-efectivo" name="efectivo">
          </div>
          <div class="col">
            <label>Transferencia</label>
            <input type="number" step="0.01" class="form-control" id="mesa-transferencia" name="transferencia">
          </div>
        </div>

        <div class="d-flex justify-content-between mt-3">
          <button type="submit" class="btn btn-success">💾 Confirmar cobro</button>
          <a id="mesa-ver-ticket" href="#" target="_blank" class="btn btn-outline-primary d-none">Ver ticket</a>
        </div>
      </form>
    </div>
  `);

  // Reasignar eventos después de reemplazar el contenido
  $('#mesa-forma-pago').on('change', function() {
    $('#mesa-dividido').toggle(this.value === 'dividido');
  });

  $('#formCobroMesa').on('submit', function(e) {
    e.preventDefault();
    const btn = this.querySelector('button[type="submit"]');
    btn.disabled = true;

    const fd = new FormData(this);
    const mesaId = parseInt(fd.get('mesa_id'));
    const forma = fd.get('forma_pago');
    const total = parseFloat(fd.get('monto')) || 0;

    // Ajustar totales según forma de pago
    if (forma === 'efectivo') {
      fd.set('efectivo', total.toFixed(2));
      fd.set('transferencia', '0.00');
    } else if (forma === 'transferencia') {
      fd.set('transferencia', total.toFixed(2));
      fd.set('efectivo', '0.00');
    }
    const productosSeleccionados = {};
    $('#productos_mesa_' + mesaId + ' li').each(function() {
      const id = $(this).data('id');
      const precio = $(this).data('precio');
    
      if (!productosSeleccionados[id]) {
        productosSeleccionados[id] = { id: id, precio: precio, cantidad: 1 };
      } else {
        productosSeleccionados[id].cantidad++;
      }
    });
    fd.append('productos_json', JSON.stringify(Object.values(productosSeleccionados)));

    fd.append('productos_json', JSON.stringify(productosSeleccionados));

    fetch('ajax/guardar_cobro_mesa.php', {
      method: 'POST',
      body: fd
    })
    .then(r => r.json())
    .then(data => {
      if (data.success && data.ticket_id) {
        const modalContent = $('#modalCobroMesa .modal-content');
        modalContent.html(`
          <div class="p-3 text-center">
            <h5 class="text-success mb-3">✅ Cobro registrado correctamente</h5>
            <div class="d-flex justify-content-center gap-3">
              <button onclick="window.open('ver_ticket_mesa.php?id=${data.ticket_id}', '_blank')" class="btn btn-primary">
                Ver Ticket
              </button>
              <button onclick="window.open('ver_ticket_mesa.php?id=${data.ticket_id}&print=1', '_blank')" class="btn btn-secondary">
                Imprimir
              </button>
              <button onclick="finalizarMesa()" class="btn btn-success">
                Finalizar
              </button>
            </div>
          </div>
        `);
      } else {
        alert('❌ Error: ' + (data.error || 'Error desconocido'));
      }
    })
    .catch(() => alert('❌ Error al guardar'))
    .finally(() => btn.disabled = false);
  });

  const modal = new bootstrap.Modal(document.getElementById('modalCobroMesa'));
  modal.show();
}

function finalizarMesa() {
  // 1. Limpiar localStorage
  localStorage.removeItem('mesa_'+mesaId+'_state');
  
  // 2. Recargar completamente la página
  location.reload(true);
}

// ---------- PERSISTENCIA LOCAL ----------
const mesaId = <?php echo $mesa_id; ?>;

function saveMesaState(id){
  const form = $('#form_mesa_'+id);
  const state = {
    cliente: form.find('[name="cliente"]').val() || '',
    hora: form.find('[name="hora"]').val() || '',
    productos: []
  };
  $('#productos_mesa_'+id+' li').each(function(){
    state.productos.push({
      id: $(this).data('id'),
      nombre: $(this).data('nombre'),
      precio: $(this).data('precio')
    });
  });
  localStorage.setItem('mesa_'+id+'_state', JSON.stringify(state));
}

function loadMesaState(id){
  const raw = localStorage.getItem('mesa_'+id+'_state');
  if(!raw) return;
  try{
    const state = JSON.parse(raw);
    const form = $('#form_mesa_'+id);
    form.find('[name="cliente"]').val(state.cliente);
    form.find('[name="hora"]').val(state.hora);

    const lista = $('#productos_mesa_'+id);
    lista.empty();
    state.productos.forEach(p=>{
      const li = $('<li class="list-group-item d-flex justify-content-between align-items-center"></li>');
      li.text(p.nombre+' - $'+parseFloat(p.precio).toFixed(2));
      li.attr({'data-id':p.id,'data-precio':p.precio,'data-nombre':p.nombre});
      $('<span class="badge bg-danger" style="cursor:pointer;">✕</span>').appendTo(li).on('click',()=>{
        li.remove();
        actualizarTicketMesa(id);
        saveMesaState(id);
      });
      lista.append(li);
    });
    actualizarTicketMesa(id);
  }catch(e){}
}

$(document).ready(()=>{
  loadMesaState(mesaId);
  
  // Guardar cambios en inputs
  $('#form_mesa_'+mesaId+' [name="cliente"], #form_mesa_'+mesaId+' [name="hora"]').on('input change', ()=>saveMesaState(mesaId));
  
  // Evento para forma de pago
  $(document).on('change', '#mesa-forma-pago', function() {
    $('#mesa-dividido').toggle(this.value === 'dividido');
  });
});
// 🔄 Escuchar mensaje desde bar.php para contar productos
window.addEventListener("message", function (event) {
  if (event.data?.action === "verificar_productos") {
    try {
      const id = 3;
      const raw = localStorage.getItem('mesa_' + id + '_state');
      const state = raw ? JSON.parse(raw) : null;
      const cantidad = state && state.productos ? state.productos.length : 0;
      window.parent.postMessage({ mesa: id, productos: cantidad }, "*");
    } catch (e) {
      window.parent.postMessage({ mesa: 1, productos: 0 }, "*");
    }
  }
});
</script>
</body>
</html>