<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Catálogo</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <link rel="icon" href="../img/logo.png" type="image/png">
  <style>
    :root{
      --primary-color: #000000;
      --secondary-color: #ffb50a;
      --accent-color: #ffcc33;
      --light-color: #f8f9fa;
      --dark-color: #212529;
      --success-color: #38b000;
      --warning-color: #dc3545
    }
    
    body{
      background: linear-gradient(135deg, #ffb50a 0%, #ffcc33 100%);
      font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
      min-height: 100vh
    }
    
    .navbar{
      background: linear-gradient(to right, var(--primary-color), #1a1a1a) !important;
      box-shadow: 0 4px 12px rgba(0,0,0,.1)
    }
    
    .navbar-brand{
      font-weight: 700;
      letter-spacing: .5px;
      background: linear-gradient(to right, var(--secondary-color), #ffcc33);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    
    .nav-link{
      font-weight: 500;
      padding: .5rem 1rem;
      border-radius: .5rem;
      transition: all .3s ease
    }
    
    .nav-link:hover, .nav-link.active{
      background-color: rgba(255, 181, 10, 0.15);
      color: var(--secondary-color) !important;
      transform: translateY(-2px)
    }
    
    .container{
      max-width: 1200px
    }
    
    h2{
      color: var(--dark-color);
      font-weight: 700;
      position: relative;
      padding-bottom: 15px;
      margin-bottom: 30px
    }
    
    h2:after{
      content: '';
      position: absolute;
      bottom: 0;
      left: 50%;
      transform: translateX(-50%);
      width: 80px;
      height: 4px;
      background: linear-gradient(to right, var(--primary-color), var(--accent-color));
      border-radius: 2px
    }
    
    .card{
      border: none;
      border-radius: 12px;
      overflow: hidden;
      transition: all .3s cubic-bezier(.25,.8,.25,1);
      background-color: #fff;
      box-shadow: 0 4px 6px rgba(0,0,0,.05);
      height: 100%
    }
    
    .card:hover{
      transform: translateY(-8px);
      box-shadow: 0 14px 28px rgba(0,0,0,.1), 0 10px 10px rgba(0,0,0,.05)
    }
    
    .card-img-top{
      height: 200px;
      object-fit: cover;
      transition: transform .3s ease
    }
    
    .card:hover .card-img-top{
      transform: scale(1.03)
    }
    
    .card-body{
      padding: 1.5rem
    }
    
    .card-title{
      font-weight: 700;
      color: var(--dark-color);
      margin-bottom: .75rem
    }
    
    .card-text{
      color: #6c757d;
      margin-bottom: .5rem
    }
    
    .price-tag{
      font-weight: 700;
      color: var(--primary-color);
      font-size: 1.25rem
    }
    
    .price-tag.muted{
      color: #6c757d
    }
    
    .detail-link{
      display: inline-block;
      transition: all .3s ease;
      color: var(--accent-color) !important
    }
    
    .detail-link:hover{
      transform: translateX(5px);
      text-decoration: none !important
    }
    
    .modal-content{
      border: none;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 10px 25px rgba(0,0,0,.2)
    }
    
    .modal-header{
      background: linear-gradient(to right, var(--primary-color), #1a1a1a);
      color: #fff;
      border-bottom: none
    }
    
    .modal-title{
      font-weight: 700
    }
    
    .modal-title i {
      color: var(--secondary-color);
    }
    
    .btn-close{
      filter: invert(1)
    }
    
    .modal-body img{
      max-height: 400px;
      object-fit: contain;
      border-radius: 8px;
      margin-bottom: 1.5rem;
      box-shadow: 0 4px 8px rgba(0,0,0,.1)
    }
    
    .btn-whatsapp{
      background-color: #25D366;
      border: none;
      font-weight: 600;
      transition: all .3s ease;
      color: white;
    }
    
    .btn-whatsapp:hover{
      background-color: #128C7E;
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(18,140,126,.3);
      color: white;
    }
    
    @media(max-width: 768px){
      .card-img-top{
        height: 180px
      }
      
      h2{
        font-size: 1.8rem
      }
    }
  </style>
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark sticky-top">
  <div class="container">
    <a class="navbar-brand d-flex align-items-center" href="#">
    <img src="../img/logo.png" alt="Logo" style="height:32px; border-radius:8px; margin-right:8px;">
    Catálogo <span class="text-brand">Generadores Argentina</span>
  </a>

    </a>
    <div class="ms-auto">
      <a class="btn btn-outline-light" href="../index.html">
        <i class="fas fa-arrow-left me-1"></i> Volver
      </a>
    </div>
  </div>
</nav>

<div class="container py-5">
  <div class="row row-cols-1 row-cols-md-3 g-4">
    <?php
    $dir = __DIR__ . '/publicaciones';
    $webDir = 'publicaciones';
    $index = 0;
    if (is_dir($dir)) {
      foreach (glob($dir . '/*.json') as $archivo) {
        $data = json_decode(file_get_contents($archivo), true);
        if (!$data) continue;
        $id_modal  = 'modal' . ($index++);
        $titulo    = htmlspecialchars($data['titulo'] ?? '');
        $contenido = htmlspecialchars($data['contenido'] ?? '');
        $precioRaw = $data['precio'] ?? null; // puede venir null
        $link      = isset($data['link']) ? trim($data['link']) : '';
        $imagen    = $data['imagen'] ?? '';

        // Formateo de precio (si querés mantener x1000, aplico sólo si hay precio)
        $hayPrecio = ($precioRaw !== null && $precioRaw !== '' && is_numeric($precioRaw));
        $precioFmt = $hayPrecio ? '$' . number_format(((float)$precioRaw) * 1000, 0, ',', '.') : 'Consultar precio';

        echo '<div class="col">';
        echo '<div class="card h-100" style="width: 22rem; padding: 20px; font-size: 1.1rem;">';

        if (!empty($imagen) && file_exists($dir . '/' . $imagen)) {
          echo '<a href="#" class="d-block overflow-hidden" data-bs-toggle="modal" data-bs-target="#' . $id_modal . '">';
          echo '<img src="' . $webDir . '/' . htmlspecialchars($imagen) . '" class="card-img-top" style="height: 250px; object-fit: cover;" alt="' . $titulo . '">';
          echo '</a>';
        }

        echo '<div class="card-body d-flex flex-column">';
        echo '<h5 class="card-title">' . $titulo . '</h5>';
        $excerpt = (mb_strlen($contenido) > 100) ? mb_substr($contenido, 0, 100) . '…' : $contenido;
        echo '<p class="card-text flex-grow-1">' . $excerpt . '</p>';

        echo '<div class="d-flex justify-content-between align-items-center mt-auto">';
        if ($hayPrecio) {
          echo '<span class="price-tag">' . $precioFmt . '</span>';
        } else {
          echo '<span class="price-tag muted">' . $precioFmt . '</span>';
        }
        echo '<a href="#" class="detail-link ver-mas" data-bs-toggle="modal" data-bs-target="#' . $id_modal . '">Ver más <i class="fas fa-chevron-right ms-1"></i></a>';
        echo '</div>'; // /d-flex
        echo '</div>'; // /card-body
        echo '</div>'; // /card
        echo '</div>'; // /col

        // MODAL
        echo '<div class="modal fade" id="' . $id_modal . '" tabindex="-1" aria-hidden="true">';
        echo '<div class="modal-dialog modal-dialog-centered modal-lg"><div class="modal-content">';
        echo '<div class="modal-header"><h5 class="modal-title"><i class="fas fa-tag me-2"></i>' . $titulo . '</h5>';
        echo '<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button></div>';
        echo '<div class="modal-body"><div class="row">';

        echo '<div class="col-md-6 mb-3 mb-md-0">';
        if (!empty($imagen) && file_exists($dir . '/' . $imagen)) {
          echo '<a href="' . $webDir . '/' . htmlspecialchars($imagen) . '" target="_blank" rel="noopener noreferrer" class="d-block">';
          echo '<img src="' . $webDir . '/' . htmlspecialchars($imagen) . '" class="img-fluid w-100 rounded" style="cursor:zoom-in;" alt="' . $titulo . '">';
          echo '</a>';
          echo '<div class="text-muted small mt-2"><i class="fa-solid fa-up-right-from-square me-1"></i>Tocá la imagen para ampliar</div>';
        } else {
          echo '<div class="text-muted">Sin imagen</div>';
        }
        echo '</div>';

        echo '<div class="col-md-6">';
        echo '<h4 class="mb-3">Detalles</h4>';
        echo '<p class="mb-4">' . nl2br($contenido) . '</p>';
        echo '<div class="d-flex align-items-center mb-3">';
        echo '<h4 class="mb-0 me-3">Precio:</h4>';
        if ($hayPrecio) {
          echo '<span class="price-tag">' . $precioFmt . '</span>';
        } else {
          echo '<span class="price-tag muted">Consultar precio</span>';
        }
        echo '</div>';

        // Botón WhatsApp
        $mensaje = "Hola, estoy interesado en: {$titulo}" . ($hayPrecio ? " - Precio: {$precioFmt}" : " - Consultar precio");
        $mensajeWA = rawurlencode($mensaje);
        echo '<div class="d-grid gap-2">';
        echo '<a href="https://wa.me/5491157131989?text=' . $mensajeWA . '" target="_blank" class="btn btn-whatsapp">';
        echo '<i class="fab fa-whatsapp me-2"></i> Consultar por WhatsApp</a>';
        echo '</div>'; // /d-grid

        echo '</div>'; // /col-md-6
        echo '</div></div>'; // /row, /modal-body

        echo '<div class="modal-footer">';
        echo '<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal"><i class="fas fa-times me-1"></i> Cerrar</button>';
        echo '</div>'; // /modal-footer

        echo '</div></div></div>'; // /content, /dialog, /modal
      }
    }
    ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>