<?php require __DIR__ . '/auth.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Dashboard de Administración</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="icon" href="../img/logo.png" type="image/png">

  <style>
    :root {
      --primary: #000000;
      --secondary: #ffb50a;
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
      --transition: all 0.3s ease;
    }
    
    body {
      background: linear-gradient(135deg, #ffb50a 0%, #ffcc33 100%);
      min-height: 100vh;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    
    .navbar {
      background: linear-gradient(90deg, var(--primary) 0%, #1a1a1a 100%) !important;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
      padding: 0.8rem 0;
    }
    
    .navbar-brand {
      font-weight: 700;
      font-size: 1.4rem;
      background: linear-gradient(to right, var(--secondary), #ffcc33);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      display: flex;
      align-items: center;
    }
    
    .navbar-brand i {
      margin-right: 10px;
      font-size: 1.6rem;
    }
    
    .nav-link {
      font-weight: 500;
      padding: 0.5rem 1rem;
      border-radius: 6px;
      margin: 0 2px;
      transition: var(--transition);
    }
    
    .nav-link:hover, .nav-link.active {
      background-color: rgba(255, 181, 10, 0.15);
      color: var(--secondary) !important;
    }
    
    .container-main {
      margin-top: 2rem;
      margin-bottom: 2rem;
    }
    
    .page-title {
      font-weight: 700;
      color: var(--primary);
      margin-bottom: 2rem;
      text-align: center;
      position: relative;
      padding-bottom: 15px;
    }
    
    .page-title:after {
      content: '';
      position: absolute;
      bottom: 0;
      left: 50%;
      transform: translateX(-50%);
      width: 100px;
      height: 4px;
      background: var(--primary);
      border-radius: 2px;
    }
    
    .card-hover {
      border: none;
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
      transition: var(--transition);
      background: white;
      height: 100%;
    }
    
    .card-hover:hover {
      transform: translateY(-10px);
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
    }
    
    .card-body {
      padding: 2.5rem 1.5rem;
      text-align: center;
      display: flex;
      flex-direction: column;
      height: 100%;
    }
    
    .dashboard-icon {
      font-size: 3.5rem;
      margin-bottom: 1.5rem;
      background: linear-gradient(135deg, var(--secondary), #ffcc33);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      height: 80px;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .card-title {
      font-weight: 700;
      color: var(--primary);
      margin-bottom: 1rem;
      font-size: 1.4rem;
    }
    
    .card-text {
      color: var(--gray);
      margin-bottom: 1.5rem;
      flex-grow: 1;
    }
    
    .btn-primary {
      background: linear-gradient(135deg, var(--primary), #333333);
      border: none;
      border-radius: 8px;
      padding: 0.7rem 1.5rem;
      font-weight: 600;
      transition: var(--transition);
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    }
    
    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
      background: linear-gradient(135deg, #333333, var(--primary));
    }
    
    .info-box {
      background: white;
      border-radius: 16px;
      padding: 2rem;
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
      margin-top: 2rem;
      border-left: 5px solid var(--secondary);
    }
    
    .info-box h5 {
      color: var(--primary);
      font-weight: 700;
      margin-bottom: 1rem;
    }
    
    .info-box p {
      color: var(--gray);
      margin-bottom: 1rem;
    }
    
    .info-box .text-muted {
      font-size: 0.9rem;
    }
    
    footer {
      background: linear-gradient(90deg, var(--primary) 0%, #1a1a1a 100%);
      color: white;
      padding: 2rem 0;
      margin-top: 3rem;
    }
    
    footer p, footer a {
      color: white;
      margin-bottom: 0.5rem;
    }
    
    footer .social-icons a {
      display: inline-block;
      margin: 0 10px;
      transition: var(--transition);
    }
    
    footer .social-icons a:hover {
      color: var(--secondary);
      transform: translateY(-2px);
    }
    
    .footer-divider {
      height: 1px;
      background: rgba(255, 255, 255, 0.2);
      margin: 1.5rem 0;
    }
    
    .stats-card {
      background: white;
      border-radius: 16px;
      padding: 1.5rem;
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
      margin-bottom: 2rem;
      text-align: center;
    }
    
    .stats-number {
      font-size: 2.5rem;
      font-weight: 700;
      color: var(--primary);
      margin-bottom: 0.5rem;
    }
    
    .stats-label {
      color: var(--gray);
      font-size: 0.9rem;
    }
    
    @media (max-width: 768px) {
      .card-body {
        padding: 2rem 1rem;
      }
      
      .dashboard-icon {
        font-size: 3rem;
        height: 70px;
      }
      
      .page-title {
        font-size: 1.8rem;
      }
    }
  </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark">
  <div class="container">
    <a class="navbar-brand" href="#">
      <i class="fas fa-cogs"></i> Panel Administración Generadores Argentina
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarContent">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarContent">
      <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link active" href="dashboard.php">
            <i class="fas fa-tachometer-alt me-1"></i> Dashboard
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="formulario.html">
            <i class="fas fa-plus-circle me-1"></i> Cargar
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="ver_publicaciones.php">
            <i class="fas fa-eye me-1"></i> Ver
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="ver_gestion.php">
            <i class="fas fa-edit me-1"></i> Administrar
          </a>
        </li>
           <li class="nav-item">
          <a class="nav-link" href="../logout.php">
            <i class="fas fa-sign-out-alt me-1"></i> Cerrar Sesión 
          </a>
        </li>
      </ul>
    </div>
  </div>
</nav>

<div class="container container-main">
  <h1 class="page-title">Panel de Publicaciones Generadores Argentina</h1>
  

  
  <div class="row g-4 justify-content-center">
    <div class="col-md-4">
      <div class="card card-hover h-100">
        <div class="card-body">
          <div class="dashboard-icon">
            <i class="fas fa-plus-circle"></i>
          </div>
          <h5 class="card-title">Cargar Nueva Publicación</h5>
          <p class="card-text">Subí una nueva publicación con título, contenido e imagen para mantener actualizado el sitio web.</p>
          <a href="formulario.html" class="btn btn-primary mt-auto">Ir a Cargar</a>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card card-hover h-100">
        <div class="card-body">
          <div class="dashboard-icon">
            <i class="fas fa-file-alt"></i>
          </div>
          <h5 class="card-title">Ver Publicaciones</h5>
          <p class="card-text">Mirá todas las publicaciones cargadas ordenadas por fecha y revisa cómo se muestran en el sitio.</p>
          <a href="ver_publicaciones.php" class="btn btn-primary mt-auto">Ver Publicaciones</a>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card card-hover h-100">
        <div class="card-body">
          <div class="dashboard-icon">
            <i class="fas fa-tools"></i>
          </div>
          <h5 class="card-title">Editar / Borrar Publicaciones</h5>
          <p class="card-text">Modificá o eliminá publicaciones existentes fácilmente con nuestra interfaz intuitiva.</p>
          <a href="ver_gestion.php" class="btn btn-primary mt-auto">Administrar</a>
        </div>
      </div>
    </div>
  </div>

  <div class="info-box">
    <h5><i class="fas fa-question-circle me-2"></i> ¿Cómo usar el panel?</h5>
    <p class="mb-3">
      Desde <strong>Cargar</strong> creás una publicación nueva (título, contenido e <em>imagen</em> JPG/PNG).
      En <strong>Ver</strong> revisás cómo queda publicada. En <strong>Administrar</strong> podés
      <strong>editar</strong> (texto, imagen, visibilidad) o <strong>eliminar</strong> publicaciones.
    </p>
    <p class="mb-0 text-muted">
      <i class="fas fa-exclamation-circle me-1"></i> Los cambios impactan <strong>al instante</strong> en la web. Recordá presionar
      <strong>Guardar</strong> antes de salir. Acceso sólo para usuarios autorizados.
      Ante dudas, contactanos por WhatsApp.
    </p>
  </div>
</div>

<footer>
  <div class="container">
    <div class="row">
      <div class="col-md-6 text-center text-md-start">
        <p class="mb-2">© 2025 NETFAN. Todos los derechos reservados.</p>
        <small class="text-white-50">Diseño y desarrollo por <a href="https://netfan.host" class="text-white">NETFAN</a></small>
      </div>
      <div class="col-md-6 text-center text-md-end mt-3 mt-md-0">
        <div class="social-icons">
          <a href="https://netfan.host" class="text-white">
            <i class="fas fa-question-circle me-1"></i> Ayuda
          </a>
          <a href="https://netfan.host" class="text-white">
            <i class="fas fa-envelope me-1"></i> Soporte
          </a>
        </div>
      </div>
    </div>
    <div class="footer-divider"></div>
    <div class="text-center">
      <small>Generadores Argentina - Panel de Administración</small>
    </div>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>