<?php
session_start();

/* Base del sitio (misma lógica que login.php).
   Para vos: /generadoresargentina.com.ar */
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
if ($base === '/') $base = '';
$loginUrl = $base . '/login.php';

// Credenciales (cambiá esto o pasamos a BD)
$USERS = [
  'admin' => 'Generadores2025!'  // ⚠️ CAMBIAR
];

// Datos
$user = isset($_POST['user']) ? trim($_POST['user']) : '';
$pass = isset($_POST['pass']) ? (string)$_POST['pass'] : '';
$next = isset($_POST['next']) ? $_POST['next'] : ($base . '/tienda/dashboard.php');

// Sanitizar $next (solo paths absolutos dentro del mismo host)
if (strpos($next, "\n") !== false || strpos($next, "\r") !== false) { $next = $base . '/tienda/dashboard.php'; }
if (!preg_match('#^/.*#', $next)) { $next = $base . '/tienda/dashboard.php'; }

// Validación simple (podemos migrar a password_hash si querés)
$ok = false;
if ($user !== '' && isset($USERS[$user])) {
  $stored = $USERS[$user];
  if (is_string($stored) && str_starts_with($stored, '$2y$')) {
    $ok = password_verify($pass, $stored);
  } else {
    $ok = hash_equals($stored, $pass);
  }
}

if (!$ok) {
  header('Location: ' . $loginUrl . '?err=1&next=' . urlencode($next));
  exit;
}

// Sesión
$_SESSION['user_id']   = $user;
$_SESSION['user_role'] = 'admin';
$_SESSION['logged_at'] = time();

// Redirección a dashboard correcto bajo /generadoresargentina.com.ar/tienda/
header('Location: ' . $next);
exit;
