<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Catálogo </title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4895ef;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4cc9f0;
            --warning-color: #f72585;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
            font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
            min-height: 100vh;
        }
        
        .navbar {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color)) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .navbar-brand {
            font-weight: 700;
            letter-spacing: 0.5px;
        }
        
        .nav-link {
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
            transition: all 0.3s ease;
        }
        
        .nav-link:hover, .nav-link.active {
            background-color: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }
        
        .container {
            max-width: 1200px;
        }
        
        h2 {
            color: var(--dark-color);
            font-weight: 700;
            position: relative;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        
        h2:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), var(--accent-color));
            border-radius: 2px;
        }
        
        .card {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
            background-color: white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            height: 100%;
        }
        
        .card:hover {
            transform: translateY(-8px);
            box-shadow: 0 14px 28px rgba(0, 0, 0, 0.1), 0 10px 10px rgba(0, 0, 0, 0.05);
        }
        
        .card-img-top {
            height: 200px;
            object-fit: cover;
            transition: transform 0.3s ease;
        }
        
        .card:hover .card-img-top {
            transform: scale(1.03);
        }
        
        .card-body {
            padding: 1.5rem;
        }
        
        .card-title {
            font-weight: 700;
            color: var(--dark-color);
            margin-bottom: 0.75rem;
        }
        
        .card-text {
            color: #6c757d;
            margin-bottom: 0.5rem;
        }
        
        .price-tag {
            font-weight: 700;
            color: var(--primary-color);
            font-size: 1.25rem;
        }
        
        .detail-link {
            display: inline-block;
            transition: all 0.3s ease;
            color: var(--accent-color) !important;
        }
        
        .detail-link:hover {
            transform: translateX(5px);
            text-decoration: none !important;
        }
        
        /* Modal Styles */
        .modal-content {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }
        
        .modal-header {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            color: white;
            border-bottom: none;
        }
        
        .modal-title {
            font-weight: 700;
        }
        
        .btn-close {
            filter: invert(1);
        }
        
        .modal-body img {
            max-height: 400px;
            object-fit: contain;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .btn-whatsapp {
            background-color: #25D366;
            border: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-whatsapp:hover {
            background-color: #128C7E;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(18, 140, 126, 0.3);
        }
        
        .btn-payment {
            background: linear-gradient(to right, #00a2ff, var(--primary-color));
            border: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-payment:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 162, 255, 0.3);
        }
        
        .mp-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin: 1rem 0;
            color: var(--primary-color);
            font-weight: 500;
        }
        
        .no-link {
            background-color: #f8f9fa;
            padding: 0.75rem;
            border-radius: 8px;
            border-left: 4px solid var(--warning-color);
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .card-img-top {
                height: 180px;
            }
            
            h2 {
                font-size: 1.8rem;
            }
        }
        
        /* Animation */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .card {
            animation: fadeIn 0.5s ease forwards;
            opacity: 0;
        }
        
        .card:nth-child(1) { animation-delay: 0.1s; }
        .card:nth-child(2) { animation-delay: 0.2s; }
        .card:nth-child(3) { animation-delay: 0.3s; }
        .card:nth-child(4) { animation-delay: 0.4s; }
        .card:nth-child(5) { animation-delay: 0.5s; }
        .card:nth-child(6) { animation-delay: 0.6s; }
    </style>
</head>
<body class="bg-light">



<div class="container py-5">
    <div class="row row-cols-1 row-cols-md-3 g-4">
        <?php
        $dir = 'publicaciones';
        $index = 0;
        if (is_dir($dir)) {
            foreach (glob($dir . '/*.json') as $archivo) {
                $data = json_decode(file_get_contents($archivo), true);
                if (!$data) continue;
                $id_modal = 'modal' . $index++;
                $titulo = htmlspecialchars($data['titulo']);
                $contenido = htmlspecialchars($data['contenido']);
                $precio = htmlspecialchars($data['precio']);
                $imagen = $data['imagen'];
                $link = isset($data['link']) ? trim($data['link']) : '';
                echo '<div class="col">';
                echo '<div class="card h-100" style="width: 22rem; padding: 20px; font-size: 1.1rem;">';
                if (!empty($imagen) && file_exists($dir . '/' . $imagen)) {
                    echo '<a href="#" data-bs-toggle="modal" data-bs-target="#' . $id_modal . '" class="d-block overflow-hidden">';
                    echo '<img src="' . $dir . '/' . $imagen . '" class="card-img-top" style="height: 250px; object-fit: cover;" alt="' . $titulo . '">';
                    echo '</a>';
                }
                echo '<div class="card-body d-flex flex-column">';
                echo '<h5 class="card-title">' . $titulo . '</h5>';
                echo '<p class="card-text flex-grow-1">' . (strlen($contenido) > 100 ? substr($contenido, 0, 100) . '...' : $contenido) . '</p>';
                echo '<div class="d-flex justify-content-between align-items-center mt-auto">';
                echo '<span class="price-tag">$' . number_format($precio * 1000, 0, ',', '.') . '</span>';
                echo '<a href="#" data-bs-toggle="modal" data-bs-target="#' . $id_modal . '" class="detail-link">Ver más <i class="fas fa-chevron-right ms-1"></i></a>';
                echo '</div>';
                echo '</div>';
                echo '</div>';
                echo '</div>';

                // MODAL COMPLETO
                echo '<div class="modal fade" id="' . $id_modal . '" tabindex="-1" aria-hidden="true">';
                echo '<div class="modal-dialog modal-dialog-centered modal-lg">';
                echo '<div class="modal-content">';
                echo '<div class="modal-header">';
                echo '<h5 class="modal-title"><i class="fas fa-tag me-2"></i>' . $titulo . '</h5>';
                echo '<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>';
                echo '</div>';
                echo '<div class="modal-body">';
                echo '<div class="row">';
                echo '<div class="col-md-6 mb-3 mb-md-0">';
                echo '<img src="' . $dir . '/' . $imagen . '" class="img-fluid w-100 rounded" alt="' . $titulo . '">';
                echo '</div>';
                echo '<div class="col-md-6">';
                echo '<h4 class="mb-3">Detalles</h4>';
                echo '<p class="mb-4">' . nl2br($contenido) . '</p>';
                echo '<div class="d-flex align-items-center mb-3">';
                echo '<h4 class="mb-0 me-3">Precio:</h4>';
                echo '<span class="price-tag">$' . number_format($precio * 1000, 0, ',', '.') . '</span>';
                echo '</div>';
                
                // Icono de MercadoPago
                echo '<div class="mp-icon">';
                echo '<i class="fab fa-cc-mastercard fa-2x text-primary"></i>';
                echo '<i class="fab fa-cc-visa fa-2x text-primary"></i>';
                echo '<span>Más métodos de pago disponibles en el local</span>';
                echo '</div>';
                
                // Botones de acción
                echo '<div class="d-grid gap-2">';
                
                // Botón WhatsApp
                $mensajeWA = rawurlencode("Hola, estoy interesado en: " . $titulo . " - Precio: $" . $precio);
                echo '<a href="https://wa.me/5491123219568?text=' . $mensajeWA . '" target="_blank" class="btn btn-whatsapp">';
                echo '<i class="fab fa-whatsapp me-2"></i> Consultar por WhatsApp</a>';
                
                // Si hay link de pago válido
                if (!empty($link)) {
                    echo '<a href="' . htmlspecialchars($link) . '" target="_blank" class="btn btn-payment">';
                    echo '<i class="fas fa-shopping-cart me-2"></i> Comprar ahora</a>';
                } else {
                    echo '<div class="no-link">';
                    echo '<i class="fas fa-exclamation-circle me-2 text-warning"></i>';
                    echo 'Actualmente no disponible para compra online';
                    echo '</div>';
                }
                
                echo '</div>'; // cierre d-grid
                echo '</div>'; // cierre col-md-6
                echo '</div>'; // cierre row
                echo '</div>'; // cierre modal-body
                echo '<div class="modal-footer">';
                echo '<button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">';
                echo '<i class="fas fa-times me-1"></i> Cerrar</button>';
                echo '</div></div></div></div>';
            }
        }
        ?>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Efecto de carga suave
    document.addEventListener('DOMContentLoaded', function() {
        setTimeout(function() {
            document.body.classList.add('loaded');
        }, 300);
    });
</script>


</body>
</html>