<?php
// login_bolsa.php
// Login específico para Bolsa de Trabajo,
// usando la MISMA tabla de usuarios que el Marketplace.

require __DIR__ . '/bolsa_auth.php';

$errores = [];
$email   = '';
$U       = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = (string)($_POST['password'] ?? '');

    if ($email === '' || $password === '') {
        $errores[] = 'Completá email y contraseña.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errores[] = 'El email no es válido.';
    } else {
        try {
            $pdo = bolsa_pdo();

            // MISMA tabla y filtro que login_market.php
            $st = $pdo->prepare("
                SELECT *
                FROM market_usuarios
                WHERE email = ? AND activo = 1
                LIMIT 1
            ");
            $st->execute([$email]);
            $U = $st->fetch(PDO::FETCH_ASSOC);
        } catch (Throwable $e) {
            // Si hay algún problema de SQL, lo mostramos genérico
            $errores[] = 'Error interno al consultar la base de datos.';
            $U = null;
        }

        if (!$errores) {
            // MISMA columna de password que login_market.php
            if (!$U || !password_verify($password, $U['password_hash'])) {
                $errores[] = 'Email o contraseña incorrectos.';
            } else {
                // Login OK: sesión PROPIA de Bolsa
                $_SESSION['bolsa_user_id'] = (int)$U['id'];

                header('Location: bolsa_trabajo.php');
                exit;
            }
        }
    }
}

function m_s($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

// Franja de fecha
setlocale(LC_TIME, 'es_AR.UTF-8', 'es_AR', 'es_ES.UTF-8', 'es_ES');
$fecha_hoy = strftime('%A %d de %B de %Y');
$fecha_hoy = ucfirst($fecha_hoy);
?>
<?php require __DIR__ . '/_head_assets.php'; ?>
<body class="bg-light">
<?php require __DIR__ . '/_navbar.php'; ?>

<!-- Franja azul con la fecha -->
<div style="background-color:#0b3254; color:#fff; padding:0.4rem 0; font-size:0.9rem;">
    <div class="container d-flex justify-content-between align-items-center flex-wrap">
        <span><?= m_s($fecha_hoy) ?></span>
        <span>Bolsa de Trabajo &mdash; Iniciar sesión</span>
    </div>
</div>

<main class="py-4 py-md-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <h1 class="h4 fw-bold mb-3 text-center">Ingresar a Bolsa de Trabajo</h1>
                <p class="text-muted small text-center mb-4">
                    Usá el mismo email y contraseña que en la Bolsa / Marketplace Fe.Tr.A.
                </p>

                <?php if ($errores): ?>
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            <?php foreach ($errores as $e): ?>
                                <li><?= m_s($e) ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="card shadow-sm border-0">
                    <div class="card-body p-4">
                        <form method="post" novalidate>
                            <div class="mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control"
                                       value="<?= m_s($email) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Contraseña</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            <button type="submit" class="btn btn-primary w-100">
                                Ingresar
                            </button>
                        </form>
                    </div>
                </div>

                <p class="text-center small mt-3">
                    ¿No tenés cuenta?
                    <a href="register_bolsa.php">Crear cuenta en Bolsa de Trabajo</a>
                </p>
            </div>
        </div>
    </div>
</main>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>
</body>
</html>
