<?php
// estado_camiones.php
require __DIR__ . '/_head_assets.php';
require __DIR__ . '/_navbar.php';
?>

<style>
    .estado-camiones-wrapper {
        padding-top: 1.5rem;
        padding-bottom: 2.5rem;
    }

    /* FRANJA AZUL DE LA FECHA */
    .fetra-date-bar {
        background: #0096d6; /* mismo azul que el resto del sitio */
        color: #fff;
        padding: 0.5rem 1rem;
        font-size: 0.9rem;
        margin-bottom: 1.5rem;
    }

    .fetra-date-bar .date-label {
        font-weight: 600;
        margin-right: 0.5rem;
    }

    .estado-camiones-title {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        text-align: center;
    }

    .estado-camiones-subtitle {
        font-size: 0.95rem;
        color: #6c757d;
        margin-bottom: 1.5rem;
        text-align: center;
    }

    /* Ventana grande que recorta arriba y a la derecha */
    .iframe-mask {
        position: relative;
        width: 100%;
        height: 900px;
        margin: 0 auto 2rem auto;
        overflow: hidden;
        border: none;
        border-radius: 0;
        box-shadow: none;
        background: transparent;
    }

    .iframe-mask iframe {
        border: 0;

        /* más ancho para poder comer el costado derecho */
        width: 115%;
        height: 1700px;

        /* CORTAMOS MÁS ARRIBA PARA QUE DESAPAREZCA LA FRANJA CELESTE */
        margin-top: -360px;   /* si ves aún 1px celeste, subí a -370 */

        /* corremos un poco a la izquierda para tapar flotantes a la derecha */
        margin-left: -6%;
    }

    .estado-camiones-note {
        font-size: 0.85rem;
        color: #888;
        text-align: center;
    }

    @media (max-width: 768px) {
        .estado-camiones-title {
            font-size: 1.5rem;
        }

        .fetra-date-bar {
            font-size: 0.85rem;
            text-align: center;
        }

        .iframe-mask {
            height: 700px;
        }

        .iframe-mask iframe {
            width: 120%;
            height: 1700px;
            margin-top: -380px;  /* un toque más de corte arriba en mobile */
            margin-left: -8%;
        }
    }
</style>

<main class="estado-camiones-wrapper">
    <div class="container-fluid px-3 px-md-4">

      <!-- DATE BAR -->
      <div class="datebar">
        <div class="container inner"><span id="fecha-hoy">—</span></div>
      </div>
      <style>
      /* Fecha */
      .datebar{background:var(--navy);color:#fff;font-weight:600}
      .datebar .inner{height:40px;display:flex;align-items:center}
      </style>

        <div class="row">
            <div class="col-12">
                <h1 class="estado-camiones-title">Estado de camiones</h1>
                <p class="estado-camiones-subtitle">
                    Información desde sistema de seguimiento en tiempo real.
                </p>

                <div class="iframe-mask">
                    <iframe src="https://agroentregas.com.ar/total-de-camiones.html" loading="lazy"></iframe>
                </div>

                <p class="estado-camiones-note">
                </p>
            </div>
        </div>
    </div>
</main>

<?php
require __DIR__ . '/_footer.php';
require __DIR__ . '/_navbar_script.php';
?>
