<?php
/* ==========================================
   enviar_comentario.php — Comentarios en Notas
   Seguro (honeypot + sanitización) y sin dependencias raras.
   Usa tu API Netfan; si falla, hace fallback a mail()
   ========================================== */

// ---------- CONFIG ----------
$para                = 'demositios2@gmail.com';             // Destino
$nombre_envio        = 'Comentarios - Fe.Tr.A';             // Remitente visible
$email_reply_default = 'no-responder@netfan.host';          // Reply-To si no hay email válido

// Volvemos a la página desde donde se envió (nota)
$referer = $_SERVER['HTTP_REFERER'] ?? 'notas.html';
$redireccion_exito   = $referer . (str_contains($referer,'?') ? '&' : '?') . 'comentario=ok';
$redireccion_error   = $referer . (str_contains($referer,'?') ? '&' : '?') . 'comentario=error';
$tiempo_redireccion  = 3;

date_default_timezone_set('America/Argentina/Cordoba');

// ---------- HELPERS ----------
function clean_line($s){
  return str_replace(["\r","\n","%0a","%0d"], '', trim((string)$s));
}
function esc_html($s){
  return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}
function b64($s){ return base64_encode((string)$s); }
function get_client_ip(){
  foreach (['HTTP_CLIENT_IP','HTTP_X_FORWARDED_FOR','REMOTE_ADDR'] as $k){
    if (!empty($_SERVER[$k])) return $_SERVER[$k];
  }
  return 'desconocida';
}

// ---------- SOLO POST ----------
if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  header("Location: $redireccion_error"); exit;
}

// ---------- HONEYPOT ----------
$honeypot  = isset($_POST['empresa']) ? trim($_POST['empresa']) : '';
if ($honeypot !== '') { // Bot
  header("Location: $redireccion_error"); exit;
}

// ---------- CAMPOS DEL FORM ----------
$comentario = isset($_POST['comentario']) ? trim($_POST['comentario']) : '';
$nombre     = isset($_POST['nombre'])     ? clean_line($_POST['nombre']) : '';
$email      = isset($_POST['email'])      ? clean_line($_POST['email'])  : '';
$web        = isset($_POST['web'])        ? clean_line($_POST['web'])    : '';
$nota_titulo= isset($_POST['nota_titulo'])? clean_line($_POST['nota_titulo']) : '';
$nota_id    = isset($_POST['nota_id'])    ? clean_line($_POST['nota_id'])    : '';

// Validaciones mínimas
if ($nombre === '' || $comentario === '') {
  header("Location: $redireccion_error"); exit;
}

$email_valido = filter_var($email, FILTER_VALIDATE_EMAIL) ? $email : '';
$comentario_html = nl2br(esc_html($comentario));

// ---------- META ----------
$ip      = esc_html(get_client_ip());
$ua      = esc_html($_SERVER['HTTP_USER_AGENT'] ?? 'n/d');
$dominio = esc_html($_SERVER['HTTP_HOST'] ?? 'n/d');
$fecha   = date('Y-m-d H:i:s');
$url     = esc_html($referer);

// ---------- HTML DEL MAIL ----------
$asunto = 'Nuevo comentario en Notas' . ($nota_titulo ? " — {$nota_titulo}" : '');

$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<style>
  body{font-family:Arial,Helvetica,sans-serif;line-height:1.6;color:#222}
  .box{background:#f7f9fc;padding:16px;border-radius:8px;border:1px solid #e5e9f2}
  .tt{color:#111;font-weight:bold}
  .muted{color:#666;font-size:13px}
  h2{margin:0 0 10px 0}
</style>
</head>
<body>
  <h2>Nuevo comentario en Notas</h2>
  <div class="box">
    <p><span class="tt">Nota:</span> {$nota_titulo}</p>
    <p><span class="tt">URL:</span> <a href="{$url}">{$url}</a></p>
    <p><span class="tt">Nombre:</span> {$nombre}</p>
    <p><span class="tt">Email:</span> {$esc_email}</p>
    <p><span class="tt">Web:</span> {$esc_web}</p>
    <p><span class="tt">Comentario:</span><br>{$comentario_html}</p>
  </div>
  <p class="muted">
    Fecha: {$fecha}<br>
    Dominio: {$dominio}<br>
    IP: {$ip}<br>
    Navegador: {$ua}
  </p>
</body>
</html>
HTML;

// Reemplazos seguros para variables escapadas
$html = str_replace(
  ['{$esc_email}','{$esc_web}'],
  [esc_html($email_valido ?: '—'), esc_html($web ?: '—')],
  $html
);

// ---------- ENVÍO POR API NETFAN ----------
$api_url = 'http://envios.netfan.host/mailer.php';
$post = [
  'html'         => b64($html),
  'asunto'       => b64($asunto),
  'nombre_envio' => b64($nombre_envio),
  'email_reply'  => b64($email_valido ?: $email_reply_default),
  'nombre'       => b64($nombre),
  'para'         => b64($para)
];

$ch = curl_init($api_url);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST           => true,
  CURLOPT_POSTFIELDS     => http_build_query($post),
  CURLOPT_TIMEOUT        => 12,
]);
$response = curl_exec($ch);
$httpcode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_err = curl_error($ch);
curl_close($ch);

$exito = ($httpcode === 200 && trim((string)$response) === 'OK');

// ---------- FALLBACK MAIL() ----------
if (!$exito) {
  $headers  = "MIME-Version: 1.0\r\n";
  $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
  $headers .= "From: ".clean_line($nombre_envio)." <{$email_reply_default}>\r\n";
  if ($email_valido) $headers .= "Reply-To: {$email_valido}\r\n";
  $exito = @mail($para, clean_line($asunto), $html, $headers);
}

// ---------- RESPUESTA VISUAL + REDIRECCIÓN ----------
header('Content-Type: text/html; charset=utf-8');
$status_ok = $exito;
$destino = $status_ok ? $redireccion_exito : $redireccion_error;
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?php echo $status_ok ? 'Comentario enviado' : 'No se pudo enviar'; ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="refresh" content="<?php echo (int)$tiempo_redireccion; ?>;url=<?php echo esc_html($destino); ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background:#f5f7fb;min-height:100vh;display:flex;align-items:center;justify-content:center;margin:0}
    .card{max-width:520px;width:92%}
  </style>
</head>
<body>
  <div class="card shadow-sm p-4 text-center">
    <?php if ($status_ok): ?>
      <div class="display-6 mb-2">✅</div>
      <h1 class="h4 mb-2">¡Comentario enviado!</h1>
      <p class="text-muted mb-4">Gracias por participar. Será revisado por el equipo.</p>
    <?php else: ?>
      <div class="display-6 mb-2">⚠️</div>
      <h1 class="h4 mb-2">No se pudo enviar el comentario</h1>
      <p class="text-muted mb-4">Intentá nuevamente. (HTTP: <?php echo (int)$httpcode; ?><?php echo $curl_err ? ', Error: '.esc_html($curl_err) : ''; ?>)</p>
    <?php endif; ?>

    <div class="d-flex align-items-center justify-content-center gap-3">
      <div class="spinner-border" role="status" aria-hidden="true"></div>
      <div class="text-muted">Redireccionando en <?php echo (int)$tiempo_redireccion; ?> segundos…</div>
    </div>
    <div class="mt-3">
      <a class="btn btn-primary btn-sm" href="<?php echo esc_html($destino); ?>">Volver ahora</a>
    </div>
  </div>
</body>
</html>
