<?php
// eliminar_producto_market.php
require __DIR__ . '/market_bootstrap.php';

// DEBUG: si algo sale mal, que muestre el error en pantalla
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!market_is_logged()) {
    header('Location: login_market.php');
    exit;
}

$pdo = market_pdo();
$U   = market_current_user();
if (!$U) {
    header('Location: logout_market.php');
    exit;
}

// ID del producto a eliminar
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: perfil_market.php');
    exit;
}

// Verificar que el producto exista y sea del usuario logueado
$st = $pdo->prepare("
    SELECT id
    FROM market_productos
    WHERE id = ? AND usuario_id = ?
    LIMIT 1
");
$st->execute([$id, (int)$U['id']]);
$P = $st->fetch(PDO::FETCH_ASSOC);

if (!$P) {
    // No existe o no es tuyo
    header('Location: perfil_market.php');
    exit;
}

try {
    // Borrar fotos asociadas
    $delFotos = $pdo->prepare("
        DELETE FROM market_productos_fotos
        WHERE producto_id = ?
    ");
    $delFotos->execute([$id]);

    // Borrar el producto
    $delProd = $pdo->prepare("
        DELETE FROM market_productos
        WHERE id = ? AND usuario_id = ?
        LIMIT 1
    ");
    $delProd->execute([$id, (int)$U['id']]);

} catch (Throwable $e) {
    // Si algo explota, mostrar el error (para que no quede en 500 mudo)
    echo "<h1>Error al eliminar producto</h1>";
    echo "<pre>" . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8') . "</pre>";
    exit;
}

// Volver al perfil
header('Location: perfil_market.php');
exit;
