<?php
@session_start();
require __DIR__ . '/db.php';

$pdo = pdo();

if (!function_exists('e')) {
  function e($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
}

// Traigo SIEMPRE todas las delegaciones, el filtro lo hace JS
$sql = "SELECT * FROM delegaciones ORDER BY provincia ASC, localidad ASC, nombre ASC";
$stmt = $pdo->query($sql);
$delegaciones = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Delegaciones — Fe.Tr.A</title>
  <?php include __DIR__ . '/_head_assets.php'; ?>

  <style>
    .delegaciones-wrapper {
      padding: 40px 0;
    }

    .delegaciones-header {
      text-align: center;
      margin-bottom: 30px;
    }
    .delegaciones-header h1 {
      font-size: 2rem;
      font-weight: 700;
      margin-bottom: 0.25rem;
    }
    .delegaciones-header p {
      margin: 0;
      color: #6c757d;
    }

    /* Buscador cápsula */
    .delegaciones-search-shell {
      display: flex;
      justify-content: center;
      margin-bottom: 30px;
    }
    .delegaciones-search {
      width: 100%;
      max-width: 600px;
    }
    .delegaciones-search-inner {
      position: relative;
      background: linear-gradient(90deg, #e7f0ff, #f0f5ff);
      border-radius: 999px;
      padding: 14px 22px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    }
    .delegaciones-search-input {
      width: 100%;
      border: none;
      outline: none;
      border-radius: 999px;
      padding: 10px 48px 10px 48px;
      font-size: 1rem;
      background: #fff;
      box-shadow: inset 0 0 0 1px rgba(0,0,0,0.03);
    }
    .delegaciones-search-input::placeholder {
      color: #9da3af;
    }
    .delegaciones-search-icon {
      position: absolute;
      left: 32px;
      top: 50%;
      transform: translateY(-50%);
      font-size: 1.2rem;
      color: #9da3af;
      pointer-events: none;
    }

    .delegaciones-meta {
      font-size: .9rem;
      color: #6c757d;
      margin-bottom: 15px;
      text-align: left;
    }

    /* ===== PARRILLA EN COLUMNAS (centrada) ===== */
    .delegaciones-grid {
      max-width: 1200px;
      margin: 0 auto;
      display: grid;
      gap: 1.5rem;
      /* en desktop centra y arma hasta 3 columnas */
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      justify-content: center;
    }

    @media (max-width: 767.98px) {
      .delegaciones-grid {
        grid-template-columns: minmax(0, 1fr); /* 1 por fila en phone */
      }
    }

    .card-delegacion {
      /* Fondo blanco con borde de gradiente sutil */
      background:
        linear-gradient(#ffffff, #ffffff) padding-box,
        linear-gradient(135deg, #e7f0ff, #f0f5ff) border-box;
      border-radius: .9rem;
      border: 1px solid transparent;
      box-shadow: 0 6px 18px rgba(0,0,0,0.06);
      padding: 16px 18px;
      height: 100%;
    }
    .card-delegacion .card-title {
      font-size: 1.02rem;
      font-weight: 600;
      margin-bottom: 6px;
    }
    .badge-provincia {
      background: #e9f2ff;
      color: #004b8d;
      font-weight: 600;
      font-size: .75rem;
      border-radius: 999px;
      padding: 0.25rem 0.6rem;
      display: inline-block;
    }
    .card-delegacion p {
      margin-bottom: .25rem;
      font-size: .92rem;
    }
    .card-delegacion p strong {
      font-weight: 600;
    }
  </style>
</head>
<body>
  <?php include __DIR__ . '/_navbar.php'; ?>

  <!-- Franja azul de fecha -->
  <div class="datebar">
    <div class="container inner"><span id="fecha-hoy">—</span></div>
  </div>

  <main class="container delegaciones-wrapper">

    <!-- Encabezado -->
    <div class="delegaciones-header">
      <h1>Delegaciones Fe.Tr.A.</h1>
      <p>Buscá y consultá todas las delegaciones del país.</p>
    </div>

    <!-- Buscador tipo cápsula -->
    <div class="delegaciones-search-shell">
      <div class="delegaciones-search">
        <div class="delegaciones-search-inner">
          <span class="delegaciones-search-icon">🔍</span>
          <input
            type="text"
            id="delegacionesSearch"
            class="delegaciones-search-input"
            placeholder="Buscar por nombre, provincia, localidad, dirección, teléfono o email"
          />
        </div>
      </div>
    </div>



    <!-- PARRILLA -->
    <?php if (!count($delegaciones)): ?>
      <div class="alert alert-info">
        No hay delegaciones cargadas.
      </div>
    <?php else: ?>
      <div class="delegaciones-grid" id="delegacionesGrid">
        <?php foreach ($delegaciones as $d): ?>
          <?php
            $texto = strtolower(
              trim(
                ($d['nombre'] ?? '') . ' ' .
                ($d['provincia'] ?? '') . ' ' .
                ($d['localidad'] ?? '') . ' ' .
                ($d['direccion'] ?? '') . ' ' .
                ($d['telefono'] ?? '') . ' ' .
                ($d['email'] ?? '')
              )
            );
          ?>
          <article class="card-delegacion delegacion-item"
                   data-text="<?= e($texto) ?>">
            <h5 class="card-title">
              <?= e($d['nombre']) ?>
            </h5>

            <p>
              <span class="badge-provincia"><?= e($d['provincia']) ?></span>
              <?php if (!empty($d['localidad'])): ?>
                <span class="text-muted"> · <?= e($d['localidad']) ?></span>
              <?php endif; ?>
            </p>

            <?php if (!empty($d['direccion'])): ?>
              <p><strong>Dirección:</strong> <?= e($d['direccion']) ?></p>
            <?php endif; ?>

            <?php if (!empty($d['telefono'])): ?>
              <p><strong>Teléfono:</strong> <?= e($d['telefono']) ?></p>
            <?php endif; ?>

            <?php if (!empty($d['email'])): ?>
              <p><strong>Email:</strong>
                <a href="mailto:<?= e($d['email']) ?>">
                  <?= e($d['email']) ?>
                </a>
              </p>
            <?php endif; ?>
          </article>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

  </main>

  <?php include __DIR__ . '/_footer.php'; ?>
  <?php include __DIR__ . '/_navbar_script.php'; ?>

  <!-- Publicidad: imprime los objetos guardados para la página "delegaciones" -->
  <script src="admin_publicidad.php?action=embed&page=delegaciones"></script>

  <script>
    // Filtro en vivo por texto
    (function () {
      const input = document.getElementById('delegacionesSearch');
      const items = Array.from(document.querySelectorAll('.delegacion-item'));
      const countEl = document.getElementById('delegacionesCount');

      function filtrar() {
        const q = (input.value || '').toLowerCase().trim();
        let visibles = 0;

        items.forEach(item => {
          const txt = item.getAttribute('data-text') || '';
          if (!q || txt.indexOf(q) !== -1) {
            item.style.display = '';
            visibles++;
          } else {
            item.style.display = 'none';
          }
        });

        if (countEl) {
          countEl.textContent = visibles;
        }
      }

      if (input) {
        input.addEventListener('input', filtrar);
      }
    })();
  </script>
</body>
</html>
