<?php
// crear_usuario_market.php
require __DIR__ . '/market_bootstrap.php';

$errores = [];
$nombre = '';
$apellido = '';
$telefono = '';
$email = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre   = trim($_POST['nombre'] ?? '');
    $apellido = trim($_POST['apellido'] ?? '');
    $telefono = trim($_POST['telefono'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $pass1    = (string)($_POST['password'] ?? '');
    $pass2    = (string)($_POST['password2'] ?? '');

    if ($nombre === '' || $apellido === '' || $telefono === '' || $email === '' || $pass1 === '' || $pass2 === '') {
        $errores[] = 'Completá todos los campos obligatorios.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errores[] = 'Email inválido.';
    } elseif ($pass1 !== $pass2) {
        $errores[] = 'Las contraseñas no coinciden.';
    } else {
        $pdo = market_pdo();

        $st = $pdo->prepare("SELECT id FROM market_usuarios WHERE email = ? LIMIT 1");
        $st->execute([$email]);
        if ($st->fetch()) {
            $errores[] = 'Ese email ya está registrado en el Marketplace.';
        } else {
            $avatar = market_upload_file('avatar', null);
            $hash   = password_hash($pass1, PASSWORD_DEFAULT);

            $stIns = $pdo->prepare("
                INSERT INTO market_usuarios (nombre, apellido, telefono, email, password_hash, avatar)
                VALUES (?, ?, ?, ?, ?, ?)
            ");
            $stIns->execute([$nombre, $apellido, $telefono, $email, $hash, $avatar]);

            $uid = (int)$pdo->lastInsertId();
            $_SESSION['market_user_id'] = $uid;

            header('Location: perfil_market.php');
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Crear cuenta - Marketplace</title>
    <?php require __DIR__ . '/_head_assets.php'; ?>
    <style>
        :root {
            --mk-primary: #00a86b;
            --mk-primary-light: #00d49f;
            --mk-primary-dark: #00885a;
            --mk-secondary: #6c757d;
            --mk-dark: #212529;
            --mk-light: #f6f7fb;
            --mk-border: #e3e4ec;
            --mk-shadow: 0 20px 45px rgba(0,0,0,0.35);
            --mk-shadow-hover: 0 25px 60px rgba(0,0,0,0.45);
            --mk-radius: 20px;
            --mk-radius-sm: 12px;
        }

        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        .mk-auth-bg {
            min-height: calc(100vh - 80px);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            background: 
                radial-gradient(circle at 20% 80%, rgba(0, 168, 107, 0.15) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(0, 212, 159, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(0, 68, 50, 0.2) 0%, transparent 50%),
                linear-gradient(135deg, #004432 0%, #002218 100%);
            position: relative;
            overflow: hidden;
        }

        .mk-auth-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%2300a86b' fill-opacity='0.03' fill-rule='evenodd'/%3E%3C/svg%3E");
            opacity: 0.4;
        }

        .mk-card-auth {
            max-width: 800px;
            width: 100%;
            background: #ffffff;
            border-radius: var(--mk-radius);
            box-shadow: var(--mk-shadow);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
            z-index: 2;
        }

        .mk-card-auth:hover {
            transform: translateY(-5px);
            box-shadow: var(--mk-shadow-hover);
        }

        .mk-card-auth-header {
            padding: 2rem 2.5rem 1.5rem;
            background: linear-gradient(135deg, var(--mk-primary), var(--mk-primary-light));
            color: #fff;
            position: relative;
            overflow: hidden;
            text-align: center;
        }

        .mk-card-auth-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.15), transparent);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { transform: translateX(-100%) rotate(45deg); }
            100% { transform: translateX(100%) rotate(45deg); }
        }

        .mk-register-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            display: block;
        }

        .mk-card-auth-header h1 {
            font-size: 1.8rem;
            margin: 0 0 0.5rem 0;
            font-weight: 700;
            position: relative;
            z-index: 2;
        }

        .mk-card-auth-header p {
            margin: 0;
            opacity: 0.95;
            font-size: 0.95rem;
            font-weight: 500;
            position: relative;
            z-index: 2;
        }

        .mk-card-auth-body {
            padding: 2rem 2.5rem 1.5rem;
        }

        .mk-card-auth-footer {
            padding: 1.5rem 2.5rem 2rem;
            background: var(--mk-light);
            border-top: 1px solid var(--mk-border);
            font-size: 0.9rem;
        }

        /* ===== FORM CONTROLS ===== */
        .mk-form-row {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
            margin-bottom: 1.5rem;
        }

        .mk-col {
            flex: 1 1 0;
            min-width: 250px;
        }

        .mk-label {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--mk-dark);
            margin-bottom: 0.5rem;
            display: block;
        }

        .mk-form-control {
            border: 1.5px solid #e0e4f0;
            border-radius: var(--mk-radius-sm);
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background: #fff;
            width: 100%;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        .mk-form-control:focus {
            outline: none;
            border-color: var(--mk-primary);
            box-shadow: 0 0 0 3px rgba(0, 168, 107, 0.1);
            background: #fff;
        }

        .mk-form-control::placeholder {
            color: #9ca3af;
            font-size: 0.9rem;
        }

        /* ===== PASSWORD TOGGLE ===== */
        .mk-password-group {
            position: relative;
        }

        .mk-password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--mk-secondary);
            cursor: pointer;
            padding: 0.25rem;
            border-radius: 4px;
            transition: color 0.3s ease;
            font-size: 0.9rem;
        }

        .mk-password-toggle:hover {
            color: var(--mk-primary);
        }

        /* ===== AVATAR SECTION ===== */
        .mk-avatar-section {
            margin-bottom: 1.5rem;
            padding: 1.5rem;
            background: linear-gradient(135deg, #f8f9fc, #ffffff);
            border-radius: var(--mk-radius-sm);
            border: 1px solid var(--mk-border);
        }

        .mk-avatar-box {
            display: flex;
            align-items: center;
            gap: 1.5rem;
            flex-wrap: wrap;
        }

        .mk-avatar-preview {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: linear-gradient(135deg, #e9ecef, #dee2e6);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #999;
            font-size: 2rem;
            overflow: hidden;
            border: 3px solid #fff;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            flex-shrink: 0;
            transition: transform 0.3s ease;
        }

        .mk-avatar-preview:hover {
            transform: scale(1.05);
        }

        .mk-avatar-preview img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .mk-avatar-upload {
            flex: 1;
            min-width: 200px;
        }

        .mk-help {
            font-size: 0.8rem;
            color: var(--mk-secondary);
            margin-top: 0.4rem;
            line-height: 1.4;
        }

        /* ===== BOTÓN PRINCIPAL ===== */
        .mk-btn {
            border: none;
            border-radius: var(--mk-radius-sm);
            font-weight: 600;
            padding: 0.8rem 1.8rem;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            width: 100%;
        }

        .mk-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .mk-btn:hover::before {
            left: 100%;
        }

        .mk-btn-primary {
            background: linear-gradient(135deg, var(--mk-primary), var(--mk-primary-light));
            color: #fff;
            box-shadow: 0 4px 15px rgba(0, 168, 107, 0.3);
            text-transform: uppercase;
            letter-spacing: 0.03em;
            font-weight: 700;
        }

        .mk-btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0, 168, 107, 0.4);
            color: #fff;
        }

        .mk-btn-icon {
            width: 18px;
            height: 18px;
        }

        /* ===== BOTONES SECUNDARIOS ===== */
        .mk-footer-buttons {
            display: flex;
            gap: 0.8rem;
            flex-wrap: wrap;
        }

        .mk-footer-buttons .mk-btn {
            flex: 1 1 140px;
            font-weight: 600;
        }

        .mk-btn-outline {
            background: transparent;
            border: 1.5px solid var(--mk-primary);
            color: var(--mk-primary);
        }

        .mk-btn-outline:hover {
            background: var(--mk-primary);
            color: #fff;
            transform: translateY(-2px);
        }

        .mk-btn-dark {
            background: transparent;
            border: 1.5px solid var(--mk-dark);
            color: var(--mk-dark);
        }

        .mk-btn-dark:hover {
            background: var(--mk-dark);
            color: #fff;
            transform: translateY(-2px);
        }

        /* ===== ALERTS MEJORADOS ===== */
        .mk-alert {
            border-radius: var(--mk-radius-sm);
            padding: 1rem 1.2rem;
            margin-bottom: 1.5rem;
            border: 1px solid transparent;
            font-size: 0.9rem;
        }

        .mk-alert-danger {
            background: linear-gradient(135deg, #f8d7da, #f5c6cb);
            border-color: #f1aeb5;
            color: #721c24;
        }

        .mk-alert ul {
            margin: 0;
            padding-left: 1.2rem;
        }

        .mk-alert li {
            margin-bottom: 0.3rem;
        }

        .mk-alert li:last-child {
            margin-bottom: 0;
        }

        /* ===== ANIMACIONES ===== */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .mk-card-auth {
            animation: fadeInUp 0.6s ease-out;
        }

        /* ===== PASSWORD STRENGTH ===== */
        .mk-password-strength {
            margin-top: 0.5rem;
            height: 4px;
            background: #e9ecef;
            border-radius: 2px;
            overflow: hidden;
        }

        .mk-password-strength-bar {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
            border-radius: 2px;
        }

        .mk-password-strength.weak .mk-password-strength-bar {
            background: #dc3545;
            width: 33%;
        }

        .mk-password-strength.medium .mk-password-strength-bar {
            background: #ffc107;
            width: 66%;
        }

        .mk-password-strength.strong .mk-password-strength-bar {
            background: #198754;
            width: 100%;
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width: 767.98px) {
            .mk-auth-bg {
                padding: 1rem 0.5rem;
                min-height: calc(100vh - 60px);
            }
            
            .mk-card-auth-header,
            .mk-card-auth-body,
            .mk-card-auth-footer {
                padding: 1.5rem 1.5rem;
            }
            
            .mk-card-auth-header h1 {
                font-size: 1.5rem;
            }
            
            .mk-register-icon {
                font-size: 2.5rem;
            }
            
            .mk-form-row {
                flex-direction: column;
                gap: 0;
            }
            
            .mk-col {
                min-width: auto;
                margin-bottom: 1rem;
            }
            
            .mk-col:last-child {
                margin-bottom: 0;
            }
            
            .mk-avatar-box {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
            }
            
            .mk-footer-buttons {
                flex-direction: column;
            }
            
            .mk-footer-buttons .mk-btn {
                flex: 1 1 auto;
            }
        }

        @media (max-width: 575.98px) {
            .mk-card-auth-header,
            .mk-card-auth-body,
            .mk-card-auth-footer {
                padding: 1.2rem 1.2rem;
            }
        }
    </style>
</head>
<body>
<?php require __DIR__ . '/_navbar.php'; ?>

<div class="mk-auth-bg">
    <div class="mk-card-auth">
        <!-- Header con icono y título -->
        <div class="mk-card-auth-header">
            <span class="mk-register-icon">👤</span>
            <h1>Crear cuenta</h1>
            <p>Unite al Marketplace de Fe.Tr.A para vender e intercambiar</p>
        </div>

        <!-- Body del formulario -->
        <div class="mk-card-auth-body">
            <?php if ($errores): ?>
                <div class="mk-alert mk-alert-danger">
                    <ul>
                        <?php foreach ($errores as $e): ?>
                            <li><?= htmlspecialchars($e, ENT_QUOTES, 'UTF-8') ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="post" enctype="multipart/form-data" action="crear_usuario_market.php" id="registerForm">
                <!-- Fila 1: Nombre y Apellido -->
                <div class="mk-form-row">
                    <div class="mk-col">
                        <label class="mk-label">Nombre</label>
                        <input class="mk-form-control" type="text" name="nombre"
                               value="<?= htmlspecialchars($nombre, ENT_QUOTES, 'UTF-8') ?>" 
                               placeholder="Tu nombre"
                               required
                               autocomplete="given-name">
                    </div>
                    <div class="mk-col">
                        <label class="mk-label">Apellido</label>
                        <input class="mk-form-control" type="text" name="apellido"
                               value="<?= htmlspecialchars($apellido, ENT_QUOTES, 'UTF-8') ?>" 
                               placeholder="Tu apellido"
                               required
                               autocomplete="family-name">
                    </div>
                </div>

                <!-- Fila 2: Teléfono y Email -->
                <div class="mk-form-row">
                    <div class="mk-col">
                        <label class="mk-label">Teléfono</label>
                        <input class="mk-form-control" type="text" name="telefono"
                               value="<?= htmlspecialchars($telefono, ENT_QUOTES, 'UTF-8') ?>" 
                               placeholder="+54 9 11 1234-5678"
                               required
                               autocomplete="tel">
                    </div>
                    <div class="mk-col">
                        <label class="mk-label">Email</label>
                        <input class="mk-form-control" type="email" name="email"
                               value="<?= htmlspecialchars($email, ENT_QUOTES, 'UTF-8') ?>" 
                               placeholder="tu.email@ejemplo.com"
                               required
                               autocomplete="email">
                    </div>
                </div>

                <!-- Fila 3: Contraseñas -->
                <div class="mk-form-row">
                    <div class="mk-col">
                        <label class="mk-label">Contraseña</label>
                        <div class="mk-password-group">
                            <input class="mk-form-control" type="password" name="password" 
                                   placeholder="Crea una contraseña segura"
                                   required
                                   autocomplete="new-password"
                                   id="passwordInput">
                            <button type="button" class="mk-password-toggle" id="togglePassword1">
                                👁️
                            </button>
                        </div>
                        <div class="mk-password-strength" id="passwordStrength">
                            <div class="mk-password-strength-bar"></div>
                        </div>
                    </div>
                    <div class="mk-col">
                        <label class="mk-label">Repetir contraseña</label>
                        <div class="mk-password-group">
                            <input class="mk-form-control" type="password" name="password2" 
                                   placeholder="Repetí tu contraseña"
                                   required
                                   autocomplete="new-password"
                                   id="passwordInput2">
                            <button type="button" class="mk-password-toggle" id="togglePassword2">
                                👁️
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Sección Avatar -->
                <div class="mk-avatar-section">
                    <label class="mk-label">Foto de perfil (opcional)</label>
                    <div class="mk-avatar-box">
                        <div class="mk-avatar-preview" id="mkAvatarPreview">
                            <span>👤</span>
                        </div>
                        <div class="mk-avatar-upload">
                            <input class="mk-form-control" type="file" name="avatar" id="avatarInput" accept="image/*">
                            <div class="mk-help">
                                Formatos: JPG, PNG, GIF • Máx: 5MB. Se mostrará junto a tus publicaciones.
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Botón de envío -->
                <button type="submit" class="mk-btn mk-btn-primary">
                    <span class="mk-btn-icon">🚀</span>
                    Crear cuenta en el Marketplace
                </button>
            </form>
        </div>

        <!-- Footer con acciones -->
        <div class="mk-card-auth-footer">
            <div class="mk-footer-buttons">
                <a href="login_market.php" class="mk-btn mk-btn-outline">
                    <span class="mk-btn-icon">🔑</span>
                    Ya tengo cuenta
                </a>
                <a href="market.php" class="mk-btn mk-btn-dark">
                    <span class="mk-btn-icon">🏪</span>
                    Ver Marketplace
                </a>
            </div>
        </div>
    </div>
</div>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const passwordInput = document.getElementById('passwordInput');
    const passwordInput2 = document.getElementById('passwordInput2');
    const togglePassword1 = document.getElementById('togglePassword1');
    const togglePassword2 = document.getElementById('togglePassword2');
    const passwordStrength = document.getElementById('passwordStrength');
    const avatarInput = document.getElementById('avatarInput');
    const avatarPreview = document.getElementById('mkAvatarPreview');
    const registerForm = document.getElementById('registerForm');

    // Toggle de visibilidad de contraseñas
    function setupPasswordToggle(input, toggle) {
        toggle.addEventListener('click', function() {
            const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
            input.setAttribute('type', type);
            toggle.textContent = type === 'password' ? '👁️' : '🔒';
        });
    }

    if (togglePassword1 && passwordInput) setupPasswordToggle(passwordInput, togglePassword1);
    if (togglePassword2 && passwordInput2) setupPasswordToggle(passwordInput2, togglePassword2);

    // Indicador de fortaleza de contraseña
    if (passwordInput && passwordStrength) {
        passwordInput.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;
            
            if (password.length >= 8) strength++;
            if (password.match(/[a-z]/) && password.match(/[A-Z]/)) strength++;
            if (password.match(/\d/)) strength++;
            if (password.match(/[^a-zA-Z\d]/)) strength++;
            
            passwordStrength.className = 'mk-password-strength';
            if (password.length > 0) {
                if (strength <= 2) {
                    passwordStrength.classList.add('weak');
                } else if (strength === 3) {
                    passwordStrength.classList.add('medium');
                } else {
                    passwordStrength.classList.add('strong');
                }
            }
        });
    }

    // Preview del avatar
    if (avatarInput && avatarPreview) {
        avatarInput.addEventListener('change', function() {
            const file = this.files && this.files[0];
            if (!file) return;
            
            // Validar tipo de archivo
            if (!file.type.startsWith('image/')) {
                alert('Por favor seleccioná una imagen válida (JPG, PNG, GIF).');
                this.value = '';
                return;
            }

            // Validar tamaño (max 5MB)
            if (file.size > 5 * 1024 * 1024) {
                alert('La imagen es demasiado grande. Máximo 5MB permitido.');
                this.value = '';
                return;
            }

            const url = URL.createObjectURL(file);
            avatarPreview.innerHTML = '';
            const img = document.createElement('img');
            img.src = url;
            avatarPreview.appendChild(img);
        });
    }

    // Validación del formulario
    if (registerForm) {
        registerForm.addEventListener('submit', function(e) {
            const requiredFields = this.querySelectorAll('[required]');
            const password = passwordInput?.value || '';
            const password2 = passwordInput2?.value || '';
            let valid = true;

            // Reset estilos
            requiredFields.forEach(field => {
                field.style.borderColor = '';
            });

            // Validar campos vacíos
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.style.borderColor = '#dc3545';
                    valid = false;
                }
            });

            // Validar coincidencia de contraseñas
            if (password !== password2) {
                if (passwordInput2) {
                    passwordInput2.style.borderColor = '#dc3545';
                }
                valid = false;
                alert('Las contraseñas no coinciden.');
            }

            // Validar fortaleza de contraseña
            if (password.length > 0 && password.length < 6) {
                if (passwordInput) {
                    passwordInput.style.borderColor = '#dc3545';
                }
                valid = false;
                alert('La contraseña debe tener al menos 6 caracteres.');
            }

            if (!valid) {
                e.preventDefault();
                // Enfocar el primer campo con error
                const firstError = this.querySelector('[style*="border-color: #dc3545"]');
                if (firstError) {
                    firstError.focus();
                }
            }
        });

        // Efecto de focus en los campos
        const inputs = registerForm.querySelectorAll('.mk-form-control');
        inputs.forEach(input => {
            input.addEventListener('focus', function() {
                this.style.borderColor = 'var(--mk-primary)';
                this.style.boxShadow = '0 0 0 3px rgba(0, 168, 107, 0.1)';
            });

            input.addEventListener('blur', function() {
                this.style.borderColor = '';
                this.style.boxShadow = '';
            });
        });
    }

    // Auto-focus en el primer campo
    const firstField = document.querySelector('input[name="nombre"]');
    if (firstField) {
        setTimeout(() => {
            firstField.focus();
        }, 400);
    }
});
</script>
</body>
</html>