<?php
// bolsa_auth.php
// Bootstrap de autenticación para Bolsa de Trabajo,
// usando la MISMA tabla de usuarios que el Marketplace.

require __DIR__ . '/db.php'; // donde está pdo()

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Devuelve el PDO compartido (misma conexión que el resto del sitio)
 */
function bolsa_pdo() {
    static $pdo = null;
    if ($pdo === null) {
        $pdo = pdo(); // usa la misma función pdo() que tu sistema
    }
    return $pdo;
}

/**
 * ¿Hay usuario logueado en Bolsa?
 */
function bolsa_is_logged(): bool {
    return !empty($_SESSION['bolsa_user_id']);
}

/**
 * Devuelve el usuario actual de Bolsa desde la tabla market_usuarios.
 * Si algo falla o el usuario ya no existe, limpia la sesión y devuelve null.
 */
function bolsa_current_user(): ?array {
    if (!bolsa_is_logged()) {
        return null;
    }

    static $cached = null;
    if ($cached !== null) {
        return $cached;
    }

    $user_id = (int)$_SESSION['bolsa_user_id'];
    $pdo     = bolsa_pdo();

    try {
        // ⚠ MISMA TABLA QUE login_market.php
        $stmt = $pdo->prepare("SELECT * FROM market_usuarios WHERE id = ? LIMIT 1");
        $stmt->execute([$user_id]);
        $u = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Throwable $e) {
        // Si la consulta falla por cualquier motivo, evitamos 500
        unset($_SESSION['bolsa_user_id']);
        return null;
    }

    if (!$u) {
        // Si el usuario ya no existe, limpiamos la sesión
        unset($_SESSION['bolsa_user_id']);
        return null;
    }

    $cached = $u;
    return $u;
}
