<?php
// autoridades.php
require __DIR__ . '/db.php';
$pdo = pdo();

// Traer autoridades
$stmt = $pdo->query("
    SELECT id, nombre, cargo, foto, orden
    FROM autoridades
    ORDER BY orden ASC, id ASC
");
$autoridades = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];

// Fecha (barra azul)
$dt = new DateTime('now', new DateTimeZone('America/Argentina/Buenos_Aires'));
$fecha_hoy = $dt->format('d/m/Y');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <?php require __DIR__ . '/_head_assets.php'; ?>
    <title>Autoridades - Fe.Tr.A</title>
    <style>
        .autoridades-hero {
            padding: 40px 0 10px 0;
        }
        .autoridades-hero h1 {
            font-size: 2rem;
            font-weight: 700;
            text-align: center;
            margin-bottom: 10px;
        }
        .barra-fecha {
            background: #005baa; /* mismo tono azul que usás en otros */
            color: #fff;
            padding: 6px 15px;
            font-size: 0.9rem;
            margin-bottom: 25px;
        }
        .barra-fecha i {
            margin-right: 5px;
        }
        .autoridades-grid {
            padding-bottom: 40px;
        }
        .autoridad-card {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            padding: 20px 15px;
            text-align: center;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
        }
        .autoridad-foto {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            margin: 0 auto 15px auto;
            border: 3px solid #005baa;
        }
        .autoridad-cargo {
            font-weight: 700;
            text-transform: uppercase;
            font-size: 0.9rem;
            color: #005baa;
            margin-bottom: 5px;
        }
        .autoridad-nombre {
            font-size: 1.05rem;
            font-weight: 600;
        }
        @media (min-width: 768px) {
            .autoridades-hero h1 {
                font-size: 2.4rem;
            }
        }
    </style>
</head>
<body>
<?php require __DIR__ . '/_navbar.php'; ?>

<div class="container autoridades-hero">
    <div class="barra-fecha">
        <i class="bi bi-calendar-event"></i>
        <?php echo htmlspecialchars($fecha_hoy, ENT_QUOTES, 'UTF-8'); ?>
    </div>

    <h1>Autoridades</h1>
    <p class="text-center mb-4">
        Comisión Directiva de la Federación de Transportadores Argentinos.
    </p>
</div>

<div class="container autoridades-grid">
    <div class="row g-4">
        <?php if (empty($autoridades)): ?>
            <div class="col-12">
                <p class="text-center text-muted">Aún no hay autoridades cargadas.</p>
            </div>
        <?php else: ?>
            <?php foreach ($autoridades as $A): ?>
                <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                    <div class="autoridad-card">
                        <?php if (!empty($A['foto'])): ?>
                            <img src="<?php echo htmlspecialchars($A['foto'], ENT_QUOTES, 'UTF-8'); ?>"
                                 alt="Foto de <?php echo htmlspecialchars($A['nombre'], ENT_QUOTES, 'UTF-8'); ?>"
                                 class="autoridad-foto">
                        <?php else: ?>
                            <div class="autoridad-foto d-flex align-items-center justify-content-center"
                                 style="background:#e9ecef;font-size:2rem;color:#6c757d;">
                                <i class="bi bi-person"></i>
                            </div>
                        <?php endif; ?>

                        <div class="autoridad-cargo">
                            <?php echo htmlspecialchars($A['cargo'], ENT_QUOTES, 'UTF-8'); ?>
                        </div>
                        <div class="autoridad-nombre">
                            <?php echo htmlspecialchars($A['nombre'], ENT_QUOTES, 'UTF-8'); ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<?php require __DIR__ . '/_footer.php'; ?>
<?php require __DIR__ . '/_navbar_script.php'; ?>
</body>
</html>
