<?php
// admin_autoridades.php
require __DIR__ . '/db.php';
$pdo = pdo();

$errores = [];
$ok      = '';

function h($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}

// =====================
// BORRAR
// =====================
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    if ($id > 0) {
        // borrar foto si existe
        $stmt = $pdo->prepare("SELECT foto FROM autoridades WHERE id = ?");
        $stmt->execute([$id]);
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            if (!empty($row['foto']) && file_exists(__DIR__ . '/' . $row['foto'])) {
                @unlink(__DIR__ . '/' . $row['foto']);
            }
        }

        $stmt = $pdo->prepare("DELETE FROM autoridades WHERE id = ? LIMIT 1");
        $stmt->execute([$id]);
        $ok = 'Autoridad eliminada correctamente.';
    }
}

// =====================
// EDITAR (cargar datos)
// =====================
$edit_id   = 0;
$edit_data = [
    'nombre' => '',
    'cargo'  => '',
    'orden'  => 0,
    'foto'   => ''
];

if (isset($_GET['edit'])) {
    $edit_id = (int)$_GET['edit'];
    if ($edit_id > 0) {
        $stmt = $pdo->prepare("SELECT * FROM autoridades WHERE id = ? LIMIT 1");
        $stmt->execute([$edit_id]);
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $edit_data = $row;
        } else {
            $edit_id = 0;
        }
    }
}

// =====================
// GUARDAR (ALTA / EDICIÓN)
// =====================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id     = (int)($_POST['id'] ?? 0);
    $nombre = trim($_POST['nombre'] ?? '');
    $cargo  = trim($_POST['cargo'] ?? '');
    $orden  = (int)($_POST['orden'] ?? 0);

    if ($nombre === '' || $cargo === '') {
        $errores[] = 'Completá nombre y cargo.';
    }

    // Manejo de foto
    $foto_final = null;

    // Carpeta de subida (ajustá si preferís otra)
    $upload_dir = __DIR__ . '/files/autoridades';
    $upload_url_base = 'files/autoridades'; // para guardar en la DB

    if (!is_dir($upload_dir)) {
        @mkdir($upload_dir, 0775, true);
    }

    if (!empty($_FILES['foto']['name'])) {
        $tmp_name = $_FILES['foto']['tmp_name'];
        $name     = basename($_FILES['foto']['name']);
        $ext      = strtolower(pathinfo($name, PATHINFO_EXTENSION));

        $allowed = ['jpg','jpeg','png','webp'];
        if (!in_array($ext, $allowed, true)) {
            $errores[] = 'Formato de imagen inválido. Usá JPG, PNG o WEBP.';
        } elseif (!is_uploaded_file($tmp_name)) {
            $errores[] = 'Error al subir la imagen.';
        } else {
            $new_name = 'autoridad_' . time() . '_' . mt_rand(1000,9999) . '.' . $ext;
            $dest     = $upload_dir . '/' . $new_name;
            if (!move_uploaded_file($tmp_name, $dest)) {
                $errores[] = 'No se pudo guardar la imagen en el servidor.';
            } else {
                $foto_final = $upload_url_base . '/' . $new_name;
            }
        }
    }

    if (empty($errores)) {
        if ($id > 0) {
            // actualización
            if ($foto_final !== null) {
                // borrar foto anterior
                $stmt = $pdo->prepare("SELECT foto FROM autoridades WHERE id = ? LIMIT 1");
                $stmt->execute([$id]);
                if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                    if (!empty($row['foto']) && file_exists(__DIR__ . '/' . $row['foto'])) {
                        @unlink(__DIR__ . '/' . $row['foto']);
                    }
                }

                $stmt = $pdo->prepare("
                    UPDATE autoridades
                    SET nombre = ?, cargo = ?, orden = ?, foto = ?
                    WHERE id = ?
                    LIMIT 1
                ");
                $stmt->execute([$nombre, $cargo, $orden, $foto_final, $id]);
            } else {
                $stmt = $pdo->prepare("
                    UPDATE autoridades
                    SET nombre = ?, cargo = ?, orden = ?
                    WHERE id = ?
                    LIMIT 1
                ");
                $stmt->execute([$nombre, $cargo, $orden, $id]);
            }

            $ok = 'Autoridad actualizada correctamente.';
        } else {
            // alta
            $stmt = $pdo->prepare("
                INSERT INTO autoridades (nombre, cargo, foto, orden, created_at)
                VALUES (?, ?, ?, ?, NOW())
            ");
            $stmt->execute([$nombre, $cargo, $foto_final, $orden]);
            $ok = 'Autoridad creada correctamente.';
        }

        // reset de edición
        $edit_id = 0;
        $edit_data = [
            'nombre' => '',
            'cargo'  => '',
            'orden'  => 0,
            'foto'   => ''
        ];
    } else {
        // mantener datos del form si hay errores
        $edit_id = $id;
        $edit_data['nombre'] = $nombre;
        $edit_data['cargo']  = $cargo;
        $edit_data['orden']  = $orden;
        // foto se mantiene la que ya tenía, salvo hubo nueva subida OK
    }
}

// =====================
// LISTADO
// =====================
$stmt = $pdo->query("
    SELECT id, nombre, cargo, foto, orden, created_at
    FROM autoridades
    ORDER BY orden ASC, id ASC
");
$items = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
?>
<div class="container my-4">
    <h2 class="mb-3">Administrar Autoridades</h2>
    <p class="text-muted">Cargá y editá las autoridades que se muestran en <code>autoridades.php</code>.</p>

    <?php if (!empty($errores)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errores as $e): ?>
                    <li><?php echo h($e); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <?php if ($ok !== ''): ?>
        <div class="alert alert-success">
            <?php echo h($ok); ?>
        </div>
    <?php endif; ?>

    <div class="card mb-4">
        <div class="card-header">
            <?php echo $edit_id > 0 ? 'Editar autoridad' : 'Nueva autoridad'; ?>
        </div>
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo (int)$edit_id; ?>">

                <div class="mb-3">
                    <label for="nombre" class="form-label">Nombre completo</label>
                    <input
                        type="text"
                        class="form-control"
                        id="nombre"
                        name="nombre"
                        value="<?php echo h($edit_data['nombre']); ?>"
                        required
                    >
                </div>

                <div class="mb-3">
                    <label for="cargo" class="form-label">Cargo / Puesto</label>
                    <input
                        type="text"
                        class="form-control"
                        id="cargo"
                        name="cargo"
                        value="<?php echo h($edit_data['cargo']); ?>"
                        placeholder="Presidente, Vicepresidente, Secretario, etc."
                        required
                    >
                </div>

                <div class="mb-3">
                    <label for="orden" class="form-label">Orden</label>
                    <input
                        type="number"
                        class="form-control"
                        id="orden"
                        name="orden"
                        value="<?php echo (int)$edit_data['orden']; ?>"
                        placeholder="0, 1, 2..."
                    >
                    <div class="form-text">Menor número = se muestra antes.</div>
                </div>

                <div class="mb-3">
                    <label for="foto" class="form-label">Foto (opcional)</label>
                    <input type="file" class="form-control" id="foto" name="foto" accept="image/*">
                    <?php if (!empty($edit_data['foto'])): ?>
                        <div class="mt-2">
                            <span class="d-block mb-1">Foto actual:</span>
                            <img src="<?php echo h($edit_data['foto']); ?>" alt="Foto actual" style="height:70px;border-radius:50%;">
                        </div>
                    <?php endif; ?>
                </div>

                <button type="submit" class="btn btn-primary">
                    <?php echo $edit_id > 0 ? 'Guardar cambios' : 'Crear autoridad'; ?>
                </button>
                <?php if ($edit_id > 0): ?>
                    <a href="admin_autoridades.php" class="btn btn-secondary ms-2">Cancelar edición</a>
                <?php endif; ?>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            Listado de autoridades
        </div>
        <div class="card-body p-0">
            <?php if (empty($items)): ?>
                <p class="p-3 mb-0 text-muted">Todavía no hay autoridades cargadas.</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-striped mb-0 align-middle">
                        <thead>
                        <tr>
                            <th style="width:70px;">Foto</th>
                            <th>Nombre</th>
                            <th>Cargo</th>
                            <th>Orden</th>
                            <th>Creado</th>
                            <th style="width:140px;">Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($items as $it): ?>
                            <tr>
                                <td>
                                    <?php if (!empty($it['foto'])): ?>
                                        <img src="<?php echo h($it['foto']); ?>" alt="" style="height:50px;border-radius:50%;">
                                    <?php else: ?>
                                        <div style="width:50px;height:50px;border-radius:50%;background:#e9ecef;display:flex;align-items:center;justify-content:center;">
                                            <i class="bi bi-person"></i>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo h($it['nombre']); ?></td>
                                <td><?php echo h($it['cargo']); ?></td>
                                <td><?php echo (int)$it['orden']; ?></td>
                                <td><?php echo h($it['created_at']); ?></td>
                                <td>
                                    <a href="admin_autoridades.php?edit=<?php echo (int)$it['id']; ?>" class="btn btn-sm btn-outline-primary">
                                        Editar
                                    </a>
                                    <a href="admin_autoridades.php?delete=<?php echo (int)$it['id']; ?>"
                                       class="btn btn-sm btn-outline-danger"
                                       onclick="return confirm('¿Seguro que querés eliminar esta autoridad?');">
                                        Eliminar
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
