<?php
// truncate_forzado.php
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../conexion.php';

try {
    // Forzar borrado completo sin restricciones
    $con->query("SET FOREIGN_KEY_CHECKS = 0");

    $tablas = [
        'comentarios_mesa',
        'comandas_cocina',
        'tickets_mesa',
        'tickets_mesa_detalle',
        'tickets_sala',
        'caja_mesa'
    ];

    foreach ($tablas as $tbl) {
        $con->query("DELETE FROM `$tbl`");
        $con->query("ALTER TABLE `$tbl` AUTO_INCREMENT = 1");
    }

    $con->query("SET FOREIGN_KEY_CHECKS = 1");

    echo json_encode(['ok' => true, 'msg' => 'Todas las tablas fueron vaciadas correctamente.']);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]);
}
?>
