<?php
require 'restringir.php'; // 馃敀 protecci贸n
require 'conexion.php';
date_default_timezone_set('America/Argentina/Buenos_Aires');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="https://nodo25.netfan.host/sistema-bar-salas/files/icon.png" type="image/png">

  <title>Dashboard</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      --primary: #6a11cb;
      --secondary: #2575fc;
      --accent: #ff3e9d;
      --dark: #1a1a2e;
      --light: #f8f9fa;
      --success: #28a745;
      --warning: #ffc107;
      --danger: #dc3545;
      --gray: #6c757d;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
      margin: 0;
      padding: 0;
      min-height: 100vh;
      color: #333;
    }
    
    .navbar {
      background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
      color: white;
      padding: 1rem 2rem;
      display: flex;
      align-items: center;
      justify-content: space-between;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      position: relative;
      z-index: 100;
    }
    
    .navbar-brand {
      font-size: 1.5rem;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .navbar-links {
      display: flex;
      gap: 1.5rem;
    }
    
    .navbar a {
      color: white;
      text-decoration: none;
      font-weight: 500;
      transition: all 0.3s ease;
      padding: 0.5rem 1rem;
      border-radius: 50px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .navbar a:hover {
      background: rgba(255,255,255,0.15);
      transform: translateY(-2px);
    }
    
    .container {
      padding: 2rem;
      max-width: 1400px;
      margin: 0 auto;
    }
    
    .header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 2rem;
    }
    
    h1 {
      font-size: 2rem;
      color: var(--dark);
      margin: 0;
      font-weight: 600;
      position: relative;
      display: inline-block;
    }
    
    h1::after {
      content: '';
      position: absolute;
      bottom: -8px;
      left: 0;
      width: 60px;
      height: 4px;
      background: linear-gradient(90deg, var(--primary), var(--secondary));
      border-radius: 2px;
    }
    
    .grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
      gap: 1.5rem;
      margin-top: 2rem;
    }
    
    .card {
      background: white;
      border-radius: 12px;
      padding: 1.5rem;
      box-shadow: 0 6px 15px rgba(0,0,0,0.05);
      transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
      border-left: 4px solid var(--primary);
      position: relative;
      overflow: hidden;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 12px 20px rgba(0,0,0,0.1);
    }
    
    .card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, rgba(106,17,203,0.05) 0%, rgba(37,117,252,0.05) 100%);
      z-index: 0;
      opacity: 0;
      transition: opacity 0.3s ease;
    }
    
    .card:hover::before {
      opacity: 1;
    }
    
    .card a {
      text-decoration: none;
      color: var(--dark);
      font-weight: 500;
      font-size: 1.1rem;
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 1rem;
      position: relative;
      z-index: 1;
      height: 100%;
    }
    
    .card-icon {
      font-size: 2.5rem;
      width: 70px;
      height: 70px;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 50%;
      background: linear-gradient(135deg, rgba(106,17,203,0.1) 0%, rgba(37,117,252,0.1) 100%);
      color: var(--primary);
    }
    
    .card:hover .card-icon {
      background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
      color: white;
    }
    
    @media (max-width: 768px) {
      .navbar {
        flex-direction: column;
        gap: 1rem;
        padding: 1rem;
      }
      
      .navbar-links {
        width: 100%;
        justify-content: space-around;
        gap: 0.5rem;
      }
      
      .navbar a {
        padding: 0.5rem;
        font-size: 0.9rem;
      }
      
      .container {
        padding: 1rem;
      }
      
      .grid {
        grid-template-columns: 1fr;
      }
    }
  </style>
</head>
<body>
    <body class="fade-in">

<style>
  body.fade-in {
    animation: fadeIn 1s ease-out forwards;
  }

  @keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }
</style>

  <div class="navbar">
    <div class="navbar-brand">
      <i class="fas fa-compass"></i>
      <span>Dashboard </span>
    </div>
    <div class="navbar-links">
      <a href="https://nodo25.netfan.host/humclubdemusica/"><i class="fas fa-home"></i> Inicio</a>
      <a href="bar.php"><i class="fas fa-arrow-left"></i> Ir a sistema Bar</a>
    <!--  <a href="index.php"><i class="fas fa-arrow-left"></i> Ir a sistema Salas</a>-->

    </div>
  </div>

  <div class="container">
    <div class="header">
      <h1>Dashboard</h1>
    </div>
    
  <!--  <div class="grid">
      <div class="card">
        <a href="admin/admin_salas.php">
          <div class="card-icon">
<i class="fas fa-headphones"></i>
          </div>
          <span>Administrar Salas</span>
        </a>
      </div>-->
      
      <div class="card">
        <a href="admin/admin_mesas.php">
          <div class="card-icon">
            <i class="fas fa-utensils"></i>
          </div>
          <span>Administrar Mesas</span>
        </a>
      </div>
      
    <!--  <div class="card">
        <a href="admin/admin_productos.php">
          <div class="card-icon">
            <i class="fas fa-microphone-alt"></i>
          </div>
          <span>Administrar Productos Salas</span>
        </a>
      </div>-->
      
      <div class="card">
        <a href="admin/admin_productos_mesas.php">
          <div class="card-icon">
            <i class="fas fa-wine-glass-alt"></i>
          </div>
          <span>Productos por Mesa</span>
        </a>
      </div>
  <!--    <div class="card">
        <a href="admin/admin_alquileres.php">
          <div class="card-icon">
            <i class="fas fa-exchange-alt"></i>
          </div>
          <span>Administrar Alquileres</span>
        </a>
      </div>-->
      <div class="card">
        <a href="admin/caja_mesas.php">
          <div class="card-icon">
<i class="fas fa-cash-register"></i>
          </div>
          <span>Cajas</span>
        </a>
      </div>
      <div class="card">
        <a href="admin/crear_usuario.php">
          <div class="card-icon">
            <i class="fas fa-user-plus"></i>
          </div>
          <span>Crear usuarios</span>
        </a>
      </div>
      <div class="card">
        <a href="mover_mapa.php">
          <div class="card-icon">
<i class="fas fa-map-marked-alt"></i>
          </div>
          <span>Mapear mesas</span>
        </a>
      </div>
  <!--  <div class="card">
        <a href="admin/editar_sala.php">
          <div class="card-icon">
            <i class="fas fa-tools"></i>
          </div>
          <span>Editar Sala</span>
        </a>-->
      </div>
    </div>
  </div>

</body>
</html>