<?php
require_once 'db.php';
$pdo = pdo();

$stmt = $pdo->prepare("SELECT * FROM modelos_casas WHERE activo = 1 ORDER BY orden ASC, id DESC");
$stmt->execute();
$modelos = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Cabañas Santiago - Viviendas Prefabricadas de Alta Calidad</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description"
        content="Fabricamos casas prefabricadas de alta calidad con distintos sistemas constructivos. Cabañas tradicionales, alpinas y diseños modernos.">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">

    <style>
        :root {
            --primary: #ffae40;
            --primary-dark: #ff9d1f;
            --primary-light: #ffc466;
            --accent-gradient: linear-gradient(135deg, #ffae40 0%, #ff9d1f 100%);
            --bg-dark: #0a0a0a;
            --bg-light: #fafafa;
            --text-dark: #1a1a1a;
            --text-muted: #666;
            --border-light: #e8e8e8;
            --shadow-sm: 0 2px 8px rgba(0, 0, 0, 0.04);
            --shadow-md: 0 4px 20px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 10px 40px rgba(0, 0, 0, 0.12);
            --shadow-xl: 0 20px 60px rgba(0, 0, 0, 0.15);
            --transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            scroll-behavior: smooth;
        }

        body {
            background: #fff;
            color: var(--text-dark);
            font-family: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            line-height: 1.7;
            overflow-x: hidden;
        }

        /* ===== NAVBAR ===== */
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .navbar.scrolled {
            box-shadow: 0 8px 40px rgba(0, 0, 0, 0.1);
        }

        .navbar-brand {
            display: flex;
            align-items: center;
            gap: 12px;
            transition: var(--transition);
        }

        .navbar-brand:hover {
            transform: translateY(-2px);
        }

        .navbar-brand img {
            height: 48px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .navbar-brand span {
            font-weight: 800;
            color: var(--text-dark);
            font-size: 1.35rem;
            letter-spacing: -0.5px;
        }

        .nav-link {
            font-weight: 500;
            color: var(--text-dark);
            padding: 8px 16px !important;
            margin: 0 4px;
            border-radius: 8px;
            transition: var(--transition);
            position: relative;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%) scaleX(0);
            width: 80%;
            height: 3px;
            background: var(--accent-gradient);
            border-radius: 3px 3px 0 0;
            transition: var(--transition);
        }

        .nav-link:hover {
            color: var(--primary);
            background: rgba(255, 174, 64, 0.08);
        }

        .nav-link:hover::before {
            transform: translateX(-50%) scaleX(1);
        }

        /* ===== HERO ===== */
        .hero {
            padding: 100px 0 80px;
            background: linear-gradient(135deg, #fff 0%, #fef8f0 100%);
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 800px;
            height: 800px;
            background: radial-gradient(circle, rgba(255, 174, 64, 0.12) 0%, transparent 70%);
            border-radius: 50%;
            animation: float 25s ease-in-out infinite;
        }

        @keyframes float {

            0%,
            100% {
                transform: translate(0, 0) rotate(0deg);
            }

            33% {
                transform: translate(30px, -30px) rotate(120deg);
            }

            66% {
                transform: translate(-20px, 20px) rotate(240deg);
            }
        }

        .hero h1 {
            font-size: 3.5rem;
            font-weight: 900;
            line-height: 1.15;
            margin-bottom: 24px;
            background: linear-gradient(135deg, var(--text-dark) 0%, #444 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -1.5px;
            animation: fadeInUp 0.8s ease;
        }

        .hero p {
            font-size: 1.1rem;
            color: var(--text-muted);
            margin-bottom: 20px;
            line-height: 1.8;
            animation: fadeInUp 0.8s ease 0.2s both;
        }

        .hero .btn {
            background: var(--accent-gradient);
            border: none;
            padding: 16px 36px;
            font-weight: 700;
            font-size: 1.05rem;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgba(255, 174, 64, 0.35);
            transition: var(--transition);
            animation: fadeInUp 0.8s ease 0.4s both;
            position: relative;
            overflow: hidden;
            color: #fff;
        }

        .hero .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: var(--transition);
        }

        .hero .btn:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 32px rgba(255, 174, 64, 0.45);
        }

        .hero .btn:hover::before {
            left: 100%;
        }

        .hero .img-fluid {
            border-radius: 24px;
            box-shadow: var(--shadow-xl);
            animation: fadeInRight 0.8s ease 0.3s both;
            transition: var(--transition);
        }

        .hero .img-fluid:hover {
            transform: scale(1.02) rotate(1deg);
            box-shadow: 0 25px 70px rgba(0, 0, 0, 0.2);
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes fadeInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }

            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        /* ===== SECTION TITLES ===== */
        .section-title {
            font-size: 2.75rem;
            font-weight: 900;
            margin-bottom: 16px;
            letter-spacing: -1px;
            position: relative;
            display: inline-block;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: -8px;
            left: 0;
            width: 60px;
            height: 5px;
            background: var(--accent-gradient);
            border-radius: 3px;
        }

        .section-subtitle {
            max-width: 780px;
            margin: 0 auto 3rem auto;
            color: var(--text-muted);
            font-size: 1.15rem;
            line-height: 1.8;
        }

        /* ===== SECTIONS ===== */
        section {
            position: relative;
        }

        .bg-light {
            background: linear-gradient(180deg, #fafafa 0%, #fff 100%) !important;
        }

        /* ===== ICON BOXES ===== */
        .icon-box {
            background: #fff;
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            border: 1px solid var(--border-light);
            height: 100%;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .icon-box::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: var(--accent-gradient);
            opacity: 0;
            transition: var(--transition);
            z-index: 0;
        }

        .icon-box:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-lg);
            border-color: var(--primary-light);
        }

        .icon-box:hover::before {
            opacity: 0.05;
        }

        .icon-box i {
            font-size: 48px;
            background: var(--accent-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 20px;
            display: block;
            transition: var(--transition);
            position: relative;
            z-index: 1;
        }

        .icon-box:hover i {
            transform: scale(1.15) rotate(5deg);
        }

        .icon-box h5,
        .icon-box h6 {
            font-weight: 700;
            margin-bottom: 12px;
            position: relative;
            z-index: 1;
        }

        .icon-box p {
            color: var(--text-muted);
            font-size: 0.95rem;
            line-height: 1.7;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        /* ===== SISTEMA CARDS ===== */
        .sistema-card {
            border: 1px solid var(--border-light);
            border-radius: 20px;
            padding: 40px 35px;
            height: 100%;
            background: #fff;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }

        .sistema-card::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: conic-gradient(from 0deg, transparent 0deg, var(--primary-light) 90deg, transparent 180deg);
            opacity: 0;
            transition: var(--transition);
        }

        .sistema-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--shadow-lg);
            border-color: var(--primary);
        }

        .sistema-card:hover::before {
            opacity: 0.03;
            animation: rotate 8s linear infinite;
        }

        @keyframes rotate {
            100% {
                transform: rotate(360deg);
            }
        }

        .sistema-card i {
            font-size: 54px;
            background: var(--accent-gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 24px;
            display: block;
            position: relative;
            z-index: 1;
        }

        .sistema-card h5 {
            font-weight: 800;
            font-size: 1.35rem;
            margin-bottom: 16px;
            position: relative;
            z-index: 1;
        }

        .sistema-card p {
            color: var(--text-muted);
            line-height: 1.8;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        /* ===== MODELOS (CARDS) ===== */
        .card-modelo {
            border: 1px solid var(--border-light);
            border-radius: 20px;
            overflow: hidden;
            transition: var(--transition);
            background: #fff;
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .card-modelo:hover {
            transform: translateY(-12px);
            box-shadow: var(--shadow-xl);
            border-color: var(--primary-light);
        }

        .card-modelo img {
            width: 100%;
            height: 260px;
            object-fit: cover;
            transition: var(--transition);
        }

        .card-modelo:hover img {
            transform: scale(1.08);
        }

        .card-modelo .p-3 {
            padding: 28px !important;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .card-modelo h5 {
            font-weight: 800;
            font-size: 1.35rem;
            margin-bottom: 16px;
            color: var(--text-dark);
        }

        .card-modelo p {
            margin-bottom: 10px;
            font-size: 0.95rem;
            color: var(--text-muted);
        }

        .card-modelo strong {
            color: var(--text-dark);
            font-weight: 700;
        }

        .btn-simular {
            background: var(--accent-gradient);
            border: none;
            font-weight: 700;
            padding: 14px 24px;
            border-radius: 12px;
            transition: var(--transition);
            box-shadow: 0 6px 20px rgba(255, 174, 64, 0.3);
            margin-top: auto;
            color: #fff;
        }

        .btn-simular:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 28px rgba(255, 174, 64, 0.4);
            color: #fff;
        }

        /* ===== ACCORDION (FAQ) ===== */
        .accordion {
            max-width: 900px;
            margin: 0 auto;
        }

        .accordion-item {
            border: 1px solid var(--border-light);
            border-radius: 16px !important;
            margin-bottom: 16px;
            overflow: hidden;
            transition: var(--transition);
        }

        .accordion-item:hover {
            box-shadow: var(--shadow-md);
        }

        .accordion-button {
            font-weight: 700;
            font-size: 1.05rem;
            padding: 20px 24px;
            background: #fff;
            color: var(--text-dark);
            border: none;
            transition: var(--transition);
        }

        .accordion-button:not(.collapsed) {
            background: var(--accent-gradient) !important;
            color: #fff !important;
            box-shadow: none;
        }

        .accordion-button:focus {
            box-shadow: none;
            border: none;
        }

        .accordion-button::after {
            filter: brightness(0);
        }

        .accordion-button:not(.collapsed)::after {
            filter: brightness(0) invert(1);
        }

        .accordion-body {
            padding: 20px 24px;
            background: #fff;
            color: var(--text-muted);
            line-height: 1.8;
        }

        /* ===== FORM ===== */
        form label {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--text-dark);
            font-size: 0.95rem;
        }

        .form-control,
        .form-select {
            border: 2px solid var(--border-light);
            border-radius: 12px;
            padding: 12px 16px;
            font-size: 0.95rem;
            transition: var(--transition);
            background: #fff;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 4px rgba(255, 174, 64, 0.1);
        }

        /* ===== FOOTER ===== */
        footer {
            background: linear-gradient(135deg, #0a0a0a 0%, #1a1a1a 100%);
            color: #fff;
            padding: 60px 0 30px;
            position: relative;
            overflow: hidden;
        }

        footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 2px;
            background: var(--accent-gradient);
        }

        footer p {
            margin-bottom: 12px;
            opacity: 0.9;
        }

        footer a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            display: inline-block;
        }

        footer a:hover {
            color: var(--primary-light);
            transform: translateY(-2px);
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width:768px) {
            .hero h1 {
                font-size: 2.2rem;
            }

            .section-title {
                font-size: 2rem;
            }

            .navbar-brand span {
                font-size: 1.15rem;
            }

            .hero {
                padding: 60px 0 40px;
            }

            .card-modelo img {
                height: 220px;
            }
        }

        /* ===== SCROLL ANIMATIONS ===== */
        .fade-in {
            opacity: 0;
            transform: translateY(30px);
            transition: opacity 0.8s ease, transform 0.8s ease;
        }

        .fade-in.visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* ===== UTILITY CLASSES ===== */
        .py-5 {
            padding-top: 80px !important;
            padding-bottom: 80px !important;
        }

        .text-center {
            text-align: center;
        }
    </style>
</head>

<body>

    <!-- NAVBAR -->
    <nav class="navbar navbar-expand-lg">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="#inicio">
                <img src="img/logo.jpeg" alt="Logo Cabañas Santiago">
                <span>Cabañas Santiago</span>
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="nav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="#inicio">Inicio</a></li>
                    <li class="nav-item"><a class="nav-link" href="#quienes">Quiénes somos</a></li>
                    <li class="nav-item"><a class="nav-link" href="#servicios">Servicios</a></li>
                    <li class="nav-item"><a class="nav-link" href="#sistemas">Sistemas</a></li>
                    <li class="nav-item"><a class="nav-link" href="#elegirnos">Por qué elegirnos</a></li>
                    <li class="nav-item"><a class="nav-link" href="#modelos">Cabañas</a></li>
                    <li class="nav-item"><a class="nav-link" href="cliente/mi_perfil.php">Mi perfil</a></li>

                    <!--<li class="nav-item"><a class="nav-link" href="#faqs">Preguntas</a></li>-->
                    <li class="nav-item"><a class="nav-link" href="#contacto">Contacto</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- HERO -->
    <section class="hero" id="inicio">
        <div class="container">
            <div class="row align-items-center g-5">

                <div class="col-md-6">
                    <h1>Cabañas y viviendas prefabricadas de alta calidad</h1>
                    <p>
                        Fabricamos casas prefabricadas en distintos sistemas constructivos y tipologías:
                        cabañas tradicionales, cabañas alpinas, casas de dos plantas en madera, diseños
                        minimalistas con placas cementicias y durlock, aberturas en algarrobo o aluminio.
                    </p>
                    <p>
                        Elegí tu modelo, simulá cómo te gustaría pagarla y un asesor te acompaña en todo el proceso,
                        desde la platea hasta la entrega llave en mano.
                    </p>
                    <a href="#modelos" class="btn btn-lg">Ver modelos y ver formas de pago</a>
                </div>

                <div class="col-md-6 text-center">
                    <img src="img/logo.jpeg" class="img-fluid rounded" alt="Cabañas Santiago - Viviendas Prefabricadas">
                </div>

            </div>
        </div>
    </section>

    <!-- QUIÉNES SOMOS -->
    <section id="quienes" class="py-5">
        <div class="container text-center">
            <h2 class="section-title">Quiénes somos</h2>
            <p class="section-subtitle">
                Cabañas Santiago es una empresa dedicada a la venta y fabricación de casas prefabricadas
                en madera de pino misionero y sistemas combinados con placas cementicias y durlock.
                Trabajamos con diversidad de tipologías para adaptarnos a tu terreno, tu proyecto y tu presupuesto.
            </p>
            <p class="section-subtitle">
                Diseñamos y construimos pensando en el confort térmico, la durabilidad y la estética,
                con terminaciones prolijas y materiales de primeras marcas en cada etapa de la obra.
            </p>
        </div>
    </section>

    <!-- SERVICIOS -->
    <section id="servicios" class="py-5 bg-light">
        <div class="container">
            <h2 class="section-title text-center">Servicios</h2>
            <p class="section-subtitle text-center">
                Acompañamos todo el proceso: desde la elección del modelo hasta la entrega final de tu casa o cabaña.
            </p>

            <div class="row g-4">
                <div class="col-md-4">
                    <div class="icon-box">
                        <i class="fa-solid fa-building"></i>
                        <h5>Venta de viviendas</h5>
                        <p>Modelos predefinidos y adaptables con distintas superficies cubiertas y galerías.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="icon-box">
                        <i class="fa-solid fa-tree"></i>
                        <h5>Fabricación en madera y placas</h5>
                        <p>Casas machimbradas, alpinas, minimalistas y de dos plantas, combinando pino misionero y
                            placas cementicias.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="icon-box">
                        <i class="fa-solid fa-handshake"></i>
                        <h5>Planes y formas de pago</h5>
                        <p>Posibilidad de contado, financiación y combinaciones con entrega de vehículo, terreno o
                            cheques.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- SISTEMAS CONSTRUCTIVOS -->
    <section id="sistemas" class="py-5">
        <div class="container">
            <h2 class="section-title text-center">Sistemas constructivos</h2>
            <p class="section-subtitle text-center">
                Podés elegir entre tres alternativas según el alcance de obra que quieras que realicemos.
            </p>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="sistema-card">
                        <i class="fa-solid fa-house"></i>
                        <h5>Sistema estructura</h5>
                        <p>
                            Paredes, techo, divisiones internas y todas las aberturas correspondientes.
                            En doble panel se colocan aislantes térmicos entre paneles y en el cielo raso,
                            además de caños corrugados y cajas rectangulares para la instalación eléctrica.
                        </p>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="sistema-card">
                        <i class="fa-solid fa-hammer"></i>
                        <h5>Estructura + plataforma</h5>
                        <p>
                            Incluye la platea de hormigón de 10&nbsp;cm de espesor con malla electrosoldada 15x15
                            en toda la superficie. Se realiza la plataforma de la casa o cabaña elegida y luego
                            se avanza con la estructura según el sistema anterior.
                        </p>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="sistema-card">
                        <i class="fa-solid fa-key"></i>
                        <h5>Sistema llave en mano</h5>
                        <p>
                            A partir de la platea y la estructura se completa la vivienda con cañerías de PVC para baño
                            y cocina,
                            placas antihumedad, cerámicos en pisos y paredes de baño y cocina, colocación de sanitarios
                            y griferías, e instalación completa de luz con plafones LED.
                        </p>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- POR QUÉ ELEGIRNOS -->
    <section id="elegirnos" class="py-5 bg-light">
        <div class="container">
            <h2 class="section-title text-center">Por qué elegirnos</h2>
            <p class="section-subtitle text-center">
                Combinamos experiencia en construcción prefabricada con materiales seleccionados y
                alternativas claras de obra para que sepas exactamente qué estás contratando.
            </p>

            <div class="row g-4">
                <div class="col-md-3 col-6">
                    <div class="icon-box">
                        <i class="fa-solid fa-medal"></i>
                        <h6>Calidad de materiales</h6>
                        <p>Madera de pino misionero, placas cementicias y durlock, aberturas en algarrobo o aluminio.
                        </p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="icon-box">
                        <i class="fa-solid fa-layer-group"></i>
                        <h6>Variedad de tipologías</h6>
                        <p>Cabañas machimbradas, alpinas, casas de dos plantas y estilos minimalistas.</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="icon-box">
                        <i class="fa-solid fa-list-check"></i>
                        <h6>Etapas claras</h6>
                        <p>Podés contratar sólo estructura, estructura con plataforma o el sistema llave en mano.</p>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="icon-box">
                        <i class="fa-solid fa-comments"></i>
                        <h6>Acompañamiento</h6>
                        <p>Te asesoramos en la elección del modelo, sistema constructivo y forma de pago.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- MODELOS (CATÁLOGO) -->
    <section id="modelos" class="py-5">
        <div class="container">
            <h2 class="section-title text-center">Modelos de cabañas y viviendas</h2>
            <p class="section-subtitle text-center">
                Elegí un modelo para ver sus metros, sistema base y precio de referencia.
                Desde ahí vas a poder simular formas de pago y enviar tu propuesta.
            </p>

            <div class="row g-4">

                <?php foreach ($modelos as $m): ?>
                    <?php
                    $img_raw = trim($m['imagen_portada'] ?? '');
                    $img_url = '';

                    if ($img_raw !== '') {
                        if (strpos($img_raw, 'uploads/') === 0) {
                            // ejemplo BD: uploads/modelos/archivo.jpg → admin/uploads/modelos/archivo.jpg
                            $img_url = 'admin/' . $img_raw;
                        } else {
                            $img_url = $img_raw;
                        }
                    }
                    ?>

                    <div class="col-md-4">
                        <div class="card-modelo">

                            <?php if ($img_url): ?>
                                <img src="<?php echo htmlspecialchars($img_url); ?>"
                                    alt="<?php echo htmlspecialchars($m['nombre']); ?>">
                            <?php else: ?>
                                <div
                                    style="width:100%;height:260px;background:linear-gradient(135deg, #f5f5f5 0%, #e8e8e8 100%);display:flex;align-items:center;justify-content:center;">
                                    <span style="color:#999;font-weight:600;">Sin imagen</span>
                                </div>
                            <?php endif; ?>

                            <div class="p-3">
                                <h5><?php echo htmlspecialchars($m['nombre']); ?></h5>

                                <p class="mb-1"><strong>Metros:</strong>
                                    <?php echo $m['metros_cubiertos']; ?> m² cubiertos
                                    <?php if ($m['metros_galeria'] > 0): ?>
                                        + <?php echo $m['metros_galeria']; ?> m² galería
                                    <?php endif; ?>
                                </p>

                                <p class="mb-1"><strong>Sistema base:</strong> <?php echo ucfirst($m['sistema_default']); ?>
                                </p>

                                <p><strong>Desde:</strong> $<?php echo number_format($m['precio_desde'], 0, ',', '.'); ?></p>

                                <a href="simular.php?id=<?php echo $m['id']; ?>" class="btn btn-simular w-100">
                                  Consultar por esta cabaña y ver formas de pago
                                </a>
                            </div>

                        </div>
                    </div>

                <?php endforeach; ?>

            </div>
        </div>
    </section>

    <!-- TRABAJOS (GALERÍA) -->
    <?php include 'galeria.php'; ?>

    <!-- FAQ -->
    <section id="faqs" class="py-5">
        <div class="container">
            <h2 class="section-title text-center">Preguntas frecuentes</h2>

            <div class="accordion" id="faqAcc">

                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button" data-bs-toggle="collapse" data-bs-target="#c1">
                            ¿En cuánto tiempo se entrega la vivienda?
                        </button>
                    </h2>
                    <div id="c1" class="accordion-collapse collapse show" data-bs-parent="#faqAcc">
                        <div class="accordion-body">
                            El plazo varía según el modelo y el sistema elegido, pero en general va desde las etapas
                            de estructura hasta la llave en mano en un periodo estimado de semanas. En tu propuesta
                            vas a ver la fecha estimada de entrega.
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#c2">
                            ¿Qué formas de pago manejan?
                        </button>
                    </h2>
                    <div id="c2" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div class="accordion-body">
                            Podés comprar de contado o combinar financiación con entrega de vehículo, terreno o cheques.
                            En el simulador vas a poder elegir la forma en que te gustaría pagar y luego un asesor
                            ajusta
                            la operación final.
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#c3">
                            ¿Trabajan sólo con madera?
                        </button>
                    </h2>
                    <div id="c3" class="accordion-collapse collapse" data-bs-parent="#faqAcc">
                        <div class="accordion-body">
                            No. Además de madera de pino misionero utilizamos placas cementicias, durlock y diferentes
                            terminaciones que permiten estilos más tradicionales o minimalistas según el proyecto.
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- CONTACTO -->
    <section id="contacto" class="py-5 bg-light">
        <div class="container">
            <h2 class="section-title text-center">Contacto</h2>
            <p class="section-subtitle text-center">
                Dejanos tu consulta y nos comunicamos con vos para asesorarte sobre modelos, sistemas y formas de pago.
            </p>

            <form action="enviar.php" method="POST" class="row g-3 mx-auto" style="max-width:700px;">
                <!-- Honeypot para bots -->
                <input type="text" name="website" style="display:none">

                <div class="col-md-6">
                    <label>Nombre</label>
                    <input type="text" name="nombre" required class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Email</label>
                    <input type="email" name="email" required class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Teléfono</label>
                    <input type="text" name="telefono" required class="form-control">
                </div>

                <div class="col-md-6">
                    <label>Motivo de consulta</label>
                    <select name="servicio" class="form-select">
                        <option value="Consulta general">Consulta general</option>
                        <option value="Cabañas">Cabañas</option>
                        <option value="Viviendas">Viviendas</option>
                    </select>
                </div>

                <div class="col-12">
                    <label>Mensaje</label>
                    <textarea name="mensaje" required class="form-control" rows="4"></textarea>
                </div>

                <div class="col-12 text-center">
                    <button class="btn btn-simular px-5 py-3" style="font-size:1.1rem;">Enviar consulta</button>
                </div>
            </form>

        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        <div class="container text-center">
            <p style="font-size:1.1rem;font-weight:600;">Cabañas Santiago — Todos los derechos reservados</p>
            <a href="#inicio"><i class="fa-solid fa-arrow-up"></i> Volver arriba</a>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Navbar scroll effect
        window.addEventListener('scroll', function () {
            const navbar = document.querySelector('.navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });

        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                const href = this.getAttribute('href');
                if (href !== '#' && href !== '') {
                    e.preventDefault();
                    const target = document.querySelector(href);
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                }
            });
        });

        // Fade-in animations on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function (entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('visible');
                }
            });
        }, observerOptions);

        // Add fade-in to sections
        document.querySelectorAll('.icon-box, .sistema-card, .card-modelo').forEach(el => {
            el.classList.add('fade-in');
            observer.observe(el);
        });
    </script>
</body>

</html>