<?php
// cliente/mi_perfil.php
@session_start();
if (empty($_SESSION['cliente_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$cliente_id = (int)$_SESSION['cliente_id'];

/* =========================
   1) Traer datos del cliente
   ========================= */
$stmt = $pdo->prepare("
    SELECT *
    FROM clientes
    WHERE id = :id
    LIMIT 1
");
$stmt->execute([':id' => $cliente_id]);
$cliente = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cliente) {
    // Por las dudas: si no encuentra el cliente, lo sacamos de sesión
    session_destroy();
    header('Location: login.php');
    exit;
}

/* =========================
   2) Traer operaciones del cliente
   ========================= */
$stmt = $pdo->prepare("
    SELECT 
        id,
        codigo_operacion,
        modelo,
        sistema,
        forma_venta,
        tipo_plan,
        estado_obra,
        fecha_alta,
        saldo_financiar,
        cuotas_cantidad,
        cuota_monto
    FROM operaciones
    WHERE cliente_id = :cli
    ORDER BY fecha_alta DESC, id DESC
");
$stmt->execute([':cli' => $cliente_id]);
$operaciones = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Mi perfil - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="panel.php">Cabañas Santiago - Clientes</a>
        <div class="d-flex">
            <span class="navbar-text me-3" style="font-size:0.9rem;">
                <?php echo h(($cliente['nombre'] ?? '').' '.($cliente['apellido'] ?? '')); ?>
                <?php if (!empty($cliente['dni'])): ?>
                    (DNI: <?php echo h($cliente['dni']); ?>)
                <?php endif; ?>
            </span>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Salir</a>
        </div>
    </div>
</nav>

<div class="container py-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="mb-0">Mi perfil</h3>
        <a href="panel.php" class="btn btn-sm btn-outline-primary">
            Ver mis operaciones
        </a>
    </div>

    <div class="row g-3 mb-4">
        <!-- Datos personales -->
        <div class="col-md-6">
            <div class="card shadow-sm h-100">
                <div class="card-body">
                    <h5 class="card-title">Datos del cliente</h5>

                    <p class="mb-1">
                        <strong>Nombre y apellido:</strong><br>
                        <?php echo h(($cliente['nombre'] ?? '').' '.($cliente['apellido'] ?? '')); ?>
                    </p>

                    <?php if (!empty($cliente['dni'])): ?>
                        <p class="mb-1">
                            <strong>DNI:</strong><br>
                            <?php echo h($cliente['dni']); ?>
                        </p>
                    <?php endif; ?>

                    <?php if (!empty($cliente['email'])): ?>
                        <p class="mb-1">
                            <strong>Email:</strong><br>
                            <?php echo h($cliente['email']); ?>
                        </p>
                    <?php endif; ?>

                    <?php if (!empty($cliente['telefono'])): ?>
                        <p class="mb-1">
                            <strong>Teléfono:</strong><br>
                            <?php echo h($cliente['telefono']); ?>
                        </p>
                    <?php endif; ?>

                    <?php if (!empty($cliente['direccion']) || !empty($cliente['localidad']) || !empty($cliente['provincia'])): ?>
                        <p class="mb-1">
                            <strong>Domicilio:</strong><br>
                            <?php echo h($cliente['direccion'] ?? ''); ?>
                            <?php if (!empty($cliente['localidad'])): ?>
                                - <?php echo h($cliente['localidad']); ?>
                            <?php endif; ?>
                            <?php if (!empty($cliente['provincia'])): ?>
                                (<?php echo h($cliente['provincia']); ?>)
                            <?php endif; ?>
                        </p>
                    <?php endif; ?>

                    <?php if (!empty($cliente['created_at'])): ?>
                        <p class="mb-1">
                            <strong>Fecha de alta en el sistema:</strong><br>
                            <?php echo h($cliente['created_at']); ?>
                        </p>
                    <?php endif; ?>

                    <?php if (!empty($cliente['observaciones'])): ?>
                        <p class="mt-2 mb-0">
                            <strong>Observaciones:</strong><br>
                            <?php echo nl2br(h($cliente['observaciones'])); ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Resumen de operaciones -->
        <div class="col-md-6">
            <div class="card shadow-sm h-100">
                <div class="card-body">
                    <h5 class="card-title">Resumen de mis operaciones</h5>

                    <?php if (empty($operaciones)): ?>
                        <div class="alert alert-info mb-0">
                            Por el momento no tenés operaciones cargadas.
                        </div>
                    <?php else: ?>
                        <p class="text-muted">
                            A continuación se muestran tus últimas  operaciones.
                            Podés ver el detalle completo desde cada vínculo.
                        </p>

                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle mb-0">
                                <thead class="table-light">
                                <tr>
                                    <th>Código</th>
                                    <th>Modelo</th>
                                    <th>Plan</th>
                                    <th>Estado obra</th>
                                    <th>Fecha alta</th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($operaciones as $o): ?>
                                    <tr>
                                        <td><?php echo h($o['codigo_operacion']); ?></td>
                                        <td><?php echo h($o['modelo']); ?></td>
                                        <td>
                                            <?php
                                            $txt_plan = trim(($o['tipo_plan'] ?? '').' / '.($o['forma_venta'] ?? ''));
                                            echo h($txt_plan);
                                            ?>
                                        </td>
                                        <td><?php echo h($o['estado_obra'] ?? ''); ?></td>
                                        <td><?php echo h($o['fecha_alta']); ?></td>
                                        <td class="text-end">
                                            <a href="operacion.php?id=<?php echo (int)$o['id']; ?>"
                                               class="btn btn-sm btn-primary">
                                                Ver detalle
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3 text-end">
                            <a href="panel.php" class="btn btn-outline-primary btn-sm">
                                Ir al panel de operaciones
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

</div>
</body>
</html>
