<?php
// cliente/login.php
@session_start();
require_once '../db.php';

$pdo = pdo();

// (opcional, para debug mientras desarrollás)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

if (!empty($_SESSION['cliente_id'])) {
    header('Location: panel.php');
    exit;
}

$errores = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $identificador = trim($_POST['identificador'] ?? '');

    if ($identificador === '') {
        $errores = 'Ingresá tu DNI.';
    } else {

        // VERSION SEGURA: solo busca por DNI porque tu tabla clientes
        // probablemente NO tiene columnas estado / codigo_acceso.
        $stmt = $pdo->prepare("
            SELECT *
            FROM clientes
            WHERE dni = :iden
            LIMIT 1
        ");
        $stmt->execute([':iden' => $identificador]);
        $cli = $stmt->fetch(PDO::FETCH_ASSOC);

        // Si más adelante agregás las columnas:
        //  - estado (ENUM o VARCHAR)
        //  - codigo_acceso (VARCHAR)
        // podés cambiar el SELECT a algo como:
        //
        // SELECT *
        // FROM clientes
        // WHERE (dni = :iden OR codigo_acceso = :iden)
        //   AND estado = 'activo'
        // LIMIT 1;

        if ($cli) {
            $_SESSION['cliente_id']       = $cli['id'];
            $_SESSION['cliente_nombre']   = $cli['nombre']  ?? '';
            $_SESSION['cliente_apellido'] = $cli['apellido']?? '';
            $_SESSION['cliente_dni']      = $cli['dni']     ?? '';

            header('Location: panel.php');
            exit;
        } else {
            $errores = 'No se encontró un cliente con ese DNI.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Acceso clientes - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="min-height:100vh;">
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-5 col-lg-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h4 class="mb-1 text-center">Cabañas Santiago</h4>
                    <p class="text-muted text-center mb-4" style="font-size:0.9rem;">
                        Portal de clientes
                    </p>

                    <?php if ($errores): ?>
                        <div class="alert alert-danger py-2">
                            <?php echo htmlspecialchars($errores, ENT_QUOTES, 'UTF-8'); ?>
                        </div>
                    <?php endif; ?>

                    <form method="post">
                        <div class="mb-3">
                            <label class="form-label">DNI</label>
                            <input type="text" name="identificador" class="form-control" required
                                   placeholder="Ej: 30123456">
                        </div>
                        <button class="btn btn-primary w-100" type="submit">
                            Ingresar
                        </button>
                    </form>

                    <p class="text-muted mt-3 mb-0" style="font-size:0.8rem;">
                        Si todavía no tenés alta en el sistema, comunicate con Cabañas Santiago.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
