<?php
// cliente/panel.php
@session_start();
if (empty($_SESSION['cliente_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

$cliente_id = (int)$_SESSION['cliente_id'];

// Traer datos del cliente
$stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = :id LIMIT 1");
$stmt->execute([':id' => $cliente_id]);
$cli = $stmt->fetch();
if (!$cli) {
    session_unset();
    session_destroy();
    header('Location: login.php');
    exit;
}

// Asegurar que tenga código de acceso
if (empty($cli['codigo_acceso'])) {
    $codigo_auto = 'CS-' . str_pad($cli['id'], 6, '0', STR_PAD_LEFT);
    $upd = $pdo->prepare("UPDATE clientes SET codigo_acceso = :codigo WHERE id = :id");
    $upd->execute([
        ':codigo' => $codigo_auto,
        ':id'     => $cli['id'],
    ]);
    $cli['codigo_acceso'] = $codigo_auto;
}

// Traer operaciones
$stmt = $pdo->prepare("
    SELECT *
    FROM operaciones
    WHERE cliente_id = :cid
    ORDER BY fecha_alta DESC
");
$stmt->execute([':cid' => $cliente_id]);
$ops = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Mi cuenta - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <span class="navbar-brand">Cabañas Santiago - Clientes</span>
        <div class="d-flex">
            <span class="navbar-text me-3" style="font-size:0.9rem;">
                <?php echo htmlspecialchars($cli['nombre'] . ' ' . $cli['apellido']); ?>
                (DNI: <?php echo htmlspecialchars($cli['dni']); ?>)
                <?php if (!empty($cli['codigo_acceso'])): ?>
                    <br><small class="text-light">
                        Código de acceso: <?php echo htmlspecialchars($cli['codigo_acceso']); ?>
                    </small>
                <?php endif; ?>
            </span>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Salir</a>
        </div>
    </div>
</nav>

<div class="container py-4">

    <?php if (!empty($_GET['bienvenido'])): ?>
        <div class="alert alert-success">
            Bienvenido/a al portal de clientes de Cabañas Santiago.
            Recordá que podés ingresar con tu DNI o con tu código de acceso:
            <strong><?php echo htmlspecialchars($cli['codigo_acceso']); ?></strong>.
        </div>
    <?php endif; ?>

    <?php if (!empty($_GET['op_creada'])): ?>
        <div class="alert alert-success">
            Tu operación fue registrada. Abajo vas a ver el resumen y podés ingresar al detalle.
        </div>
    <?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Mis operaciones</h3>
    <a href="simulador.php" class="btn btn-outline-primary btn-sm">
        Simular formas de pago
    </a>
</div>


    <?php if (empty($ops)): ?>
        <div class="alert alert-info">
            Todavía no registraste ninguna operación.
            Hacé clic en <strong>"Registrar mi compra"</strong> para cargar la casa que compraste
            y cómo la estás pagando.
        </div>
    <?php else: ?>
        <div class="row g-3">
            <?php foreach ($ops as $o): ?>

                <?php
                $precio_lista = (float)$o['precio_lista'];
                $entregas_iniciales =
                    (float)$o['senia'] +
                    (float)$o['entrega_vehiculo'] +
                    (float)$o['entrega_terreno'] +
                    (float)$o['entrega_cheques'];

                $stmtPag = $pdo->prepare("SELECT SUM(monto) AS total_pagos FROM pagos WHERE operacion_id = :op_id");
                $stmtPag->execute([':op_id' => $o['id']]);
                $rowPag = $stmtPag->fetch();
                $total_pagos = $rowPag && $rowPag['total_pagos'] !== null ? (float)$rowPag['total_pagos'] : 0;

                $pagado = $entregas_iniciales + $total_pagos;
                $saldo  = $precio_lista - $pagado;
                if ($saldo < 0) $saldo = 0;

                $porcentaje = $precio_lista > 0 ? round(($pagado / $precio_lista) * 100) : 0;
                if ($porcentaje > 100) $porcentaje = 100;
                ?>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="card-title mb-1">
                                Operación <?php echo htmlspecialchars($o['codigo_operacion']); ?>
                            </h5>
                            <p class="mb-1">
                                <strong>Modelo:</strong> <?php echo htmlspecialchars($o['modelo']); ?><br>
                                <strong>Metros:</strong>
                                <?php echo (float)$o['metros_cubiertos']; ?> m² cubiertos
                                <?php if ($o['metros_galeria'] > 0): ?>
                                    + <?php echo (float)$o['metros_galeria']; ?> m² galería
                                <?php endif; ?>
                            </p>
                            <p class="mb-1">
                                <strong>Sistema:</strong>
                                <?php echo htmlspecialchars($o['sistema']); ?><br>
                                <strong>Forma de venta:</strong>
                                <?php echo htmlspecialchars($o['forma_venta']); ?>
                            </p>

                            <p class="mb-1">
                                <strong>Precio de la vivienda:</strong><br>
                                $ <?php echo number_format($precio_lista, 2, ',', '.'); ?>
                            </p>

                            <p class="mb-1">
                                <strong>Pagado hasta hoy:</strong><br>
                                $ <?php echo number_format($pagado, 2, ',', '.'); ?>
                            </p>

                            <p class="mb-1">
                                <strong>Saldo pendiente:</strong><br>
                                $ <?php echo number_format($saldo, 2, ',', '.'); ?>
                            </p>

                            <div class="mb-2">
                                <div class="progress" style="height: 8px;">
                                    <div class="progress-bar" role="progressbar"
                                         style="width: <?php echo $porcentaje; ?>%;"
                                         aria-valuenow="<?php echo $porcentaje; ?>"
                                         aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <small class="text-muted">
                                    Avance de pagos: <?php echo $porcentaje; ?>%
                                </small>
                            </div>

                            <p class="mb-2">
                                <strong>Estado de la obra:</strong>
                                <?php echo htmlspecialchars($o['estado_obra']); ?><br>
                                <strong>Entrega estimada:</strong>
                                <?php echo $o['fecha_estimada_entrega']
                                    ? htmlspecialchars($o['fecha_estimada_entrega'])
                                    : 'A definir'; ?>
                            </p>

                            <a href="operacion.php?id=<?php echo (int)$o['id']; ?>"
                               class="btn btn-outline-primary btn-sm">
                                Ver detalle completo
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
