<?php
// admin/operacion_form.php
@session_start();
if (empty($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

$id          = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$cliente_id  = isset($_GET['cliente_id']) ? (int)$_GET['cliente_id'] : 0;
$es_edicion  = $id > 0;

$errores = [];
$op = [
    'cliente_id'           => $cliente_id,
    'codigo_operacion'     => '',
    'modelo'               => '',
    'metros_cubiertos'     => 0,
    'metros_galeria'       => 0,
    'sistema'              => 'estructura',
    'forma_venta'          => 'contado',
    'precio_lista'         => 0,
    'senia'                => 0,
    'entrega_vehiculo'     => 0,
    'entrega_terreno'      => 0,
    'entrega_cheques'      => 0,
    'saldo_financiar'      => 0,
    'cuotas_cantidad'      => 0,
    'cuota_monto'          => 0,
    'tipo_plan'            => 'ninguno',
    'porcentaje_inicio_obra' => 60,
    'estado_obra'          => 'pendiente',
    'fecha_estimada_entrega' => '',
    'fecha_entrega_real'     => '',
    'observaciones'        => '',
];

$cliente = null;

// Si es edición, traemos operación y cliente
if ($es_edicion) {
    $stmt = $pdo->prepare("SELECT * FROM operaciones WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $id]);
    $row = $stmt->fetch();
    if (!$row) {
        die('Operación no encontrada.');
    }
    $op = array_merge($op, $row);
    $cliente_id = (int)$op['cliente_id'];
}

// Traer cliente asociado
if ($cliente_id > 0) {
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $cliente_id]);
    $cliente = $stmt->fetch();
    if (!$cliente) {
        die('Cliente no encontrado.');
    }
} else {
    if (!$es_edicion) {
        die('Falta el cliente_id para crear la operación.');
    }
}

// Procesar POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $op['codigo_operacion']       = trim($_POST['codigo_operacion'] ?? '');
    $op['modelo']                 = trim($_POST['modelo'] ?? '');
    $op['metros_cubiertos']       = (float)($_POST['metros_cubiertos'] ?? 0);
    $op['metros_galeria']         = (float)($_POST['metros_galeria'] ?? 0);
    $op['sistema']                = $_POST['sistema'] ?? 'estructura';
    $op['forma_venta']            = $_POST['forma_venta'] ?? 'contado';
    $op['precio_lista']           = (float)($_POST['precio_lista'] ?? 0);
    $op['senia']                  = (float)($_POST['senia'] ?? 0);
    $op['entrega_vehiculo']       = (float)($_POST['entrega_vehiculo'] ?? 0);
    $op['entrega_terreno']        = (float)($_POST['entrega_terreno'] ?? 0);
    $op['entrega_cheques']        = (float)($_POST['entrega_cheques'] ?? 0);
    $op['saldo_financiar']        = (float)($_POST['saldo_financiar'] ?? 0);
    $op['cuotas_cantidad']        = (int)($_POST['cuotas_cantidad'] ?? 0);
    $op['cuota_monto']            = (float)($_POST['cuota_monto'] ?? 0);
    $op['tipo_plan']              = $_POST['tipo_plan'] ?? 'ninguno';
    $op['porcentaje_inicio_obra'] = (float)($_POST['porcentaje_inicio_obra'] ?? 60);
    $op['estado_obra']            = $_POST['estado_obra'] ?? 'pendiente';
    $op['fecha_estimada_entrega'] = trim($_POST['fecha_estimada_entrega'] ?? '');
    $op['fecha_entrega_real']     = trim($_POST['fecha_entrega_real'] ?? '');
    $op['observaciones']          = trim($_POST['observaciones'] ?? '');

    if ($op['modelo'] === '') {
        $errores[] = 'El modelo o nombre de la casa es obligatorio.';
    }
    if ($op['precio_lista'] <= 0) {
        $errores[] = 'El precio de lista debe ser mayor a 0.';
    }

    // Si no se cargó código, generamos uno simple
    if ($op['codigo_operacion'] === '') {
        $op['codigo_operacion'] = 'CS-' . date('YmdHis');
    }

    if (empty($errores)) {
        try {
            if ($es_edicion) {
                $sql = "
                    UPDATE operaciones
                    SET codigo_operacion = :codigo,
                        modelo           = :modelo,
                        metros_cubiertos = :mc,
                        metros_galeria   = :mg,
                        sistema          = :sistema,
                        forma_venta      = :forma,
                        precio_lista     = :precio,
                        senia            = :senia,
                        entrega_vehiculo = :ent_veh,
                        entrega_terreno  = :ent_ter,
                        entrega_cheques  = :ent_ch,
                        saldo_financiar  = :saldo,
                        cuotas_cantidad  = :cuotas_cant,
                        cuota_monto      = :cuota_monto,
                        tipo_plan        = :tipo_plan,
                        porcentaje_inicio_obra = :porc_obra,
                        estado_obra      = :estado_obra,
                        fecha_estimada_entrega = :fecha_estimada,
                        fecha_entrega_real     = :fecha_real,
                        observaciones    = :obs
                    WHERE id = :id
                ";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':codigo'        => $op['codigo_operacion'],
                    ':modelo'        => $op['modelo'],
                    ':mc'            => $op['metros_cubiertos'],
                    ':mg'            => $op['metros_galeria'],
                    ':sistema'       => $op['sistema'],
                    ':forma'         => $op['forma_venta'],
                    ':precio'        => $op['precio_lista'],
                    ':senia'         => $op['senia'],
                    ':ent_veh'       => $op['entrega_vehiculo'],
                    ':ent_ter'       => $op['entrega_terreno'],
                    ':ent_ch'        => $op['entrega_cheques'],
                    ':saldo'         => $op['saldo_financiar'],
                    ':cuotas_cant'   => $op['cuotas_cantidad'],
                    ':cuota_monto'   => $op['cuota_monto'],
                    ':tipo_plan'     => $op['tipo_plan'],
                    ':porc_obra'     => $op['porcentaje_inicio_obra'],
                    ':estado_obra'   => $op['estado_obra'],
                    ':fecha_estimada'=> $op['fecha_estimada_entrega'] ?: null,
                    ':fecha_real'    => $op['fecha_entrega_real'] ?: null,
                    ':obs'           => $op['observaciones'],
                    ':id'            => $id,
                ]);
            } else {
                $sql = "
                    INSERT INTO operaciones
                    (
                        cliente_id, codigo_operacion, modelo,
                        metros_cubiertos, metros_galeria,
                        sistema, forma_venta,
                        precio_lista, senia,
                        entrega_vehiculo, entrega_terreno, entrega_cheques,
                        saldo_financiar, cuotas_cantidad, cuota_monto,
                        tipo_plan, porcentaje_inicio_obra,
                        estado_obra, fecha_estimada_entrega, fecha_entrega_real,
                        observaciones, fecha_alta, created_at
                    )
                    VALUES
                    (
                        :cliente_id, :codigo, :modelo,
                        :mc, :mg,
                        :sistema, :forma,
                        :precio, :senia,
                        :ent_veh, :ent_ter, :ent_ch,
                        :saldo, :cuotas_cant, :cuota_monto,
                        :tipo_plan, :porc_obra,
                        :estado_obra, :fecha_estimada, :fecha_real,
                        :obs, NOW(), NOW()
                    )
                ";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    ':cliente_id'    => $cliente_id,
                    ':codigo'        => $op['codigo_operacion'],
                    ':modelo'        => $op['modelo'],
                    ':mc'            => $op['metros_cubiertos'],
                    ':mg'            => $op['metros_galeria'],
                    ':sistema'       => $op['sistema'],
                    ':forma'         => $op['forma_venta'],
                    ':precio'        => $op['precio_lista'],
                    ':senia'         => $op['senia'],
                    ':ent_veh'       => $op['entrega_vehiculo'],
                    ':ent_ter'       => $op['entrega_terreno'],
                    ':ent_ch'        => $op['entrega_cheques'],
                    ':saldo'         => $op['saldo_financiar'],
                    ':cuotas_cant'   => $op['cuotas_cantidad'],
                    ':cuota_monto'   => $op['cuota_monto'],
                    ':tipo_plan'     => $op['tipo_plan'],
                    ':porc_obra'     => $op['porcentaje_inicio_obra'],
                    ':estado_obra'   => $op['estado_obra'],
                    ':fecha_estimada'=> $op['fecha_estimada_entrega'] ?: null,
                    ':fecha_real'    => $op['fecha_entrega_real'] ?: null,
                    ':obs'           => $op['observaciones'],
                ]);

                $id = (int)$pdo->lastInsertId();
                $es_edicion = true;
            }

            header('Location: operaciones.php?cliente_id=' . (int)$cliente_id);
            exit;

        } catch (PDOException $e) {
            $errores[] = 'Error al guardar la operación: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo $es_edicion ? 'Editar' : 'Nueva'; ?> operación - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="panel.php">Cabañas Santiago - Admin</a>
        <div class="d-flex">
            <a class="btn btn-outline-light btn-sm me-2" href="clientes.php">Clientes</a>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Salir</a>
        </div>
    </div>
</nav>

<div class="container py-4">
    <h3 class="mb-1">
        <?php echo $es_edicion ? 'Editar operación' : 'Nueva operación'; ?>
    </h3>
    <p class="text-muted mb-3">
        Cliente:
        <?php echo htmlspecialchars($cliente['apellido'] . ', ' . $cliente['nombre']); ?>
        (DNI: <?php echo htmlspecialchars($cliente['dni']); ?>)
    </p>

    <?php if (!empty($errores)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errores as $e): ?>
                    <li><?php echo htmlspecialchars($e); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="post" class="row g-3">

        <div class="col-md-4">
            <label class="form-label">Código de operación</label>
            <input type="text" name="codigo_operacion" class="form-control"
                   value="<?php echo htmlspecialchars($op['codigo_operacion']); ?>"
                   placeholder="Ej: CS-000123 (si se deja vacío, se genera solo)">
        </div>

        <div class="col-md-8">
            <label class="form-label">Modelo / Nombre de la casa *</label>
            <input type="text" name="modelo" class="form-control"
                   value="<?php echo htmlspecialchars($op['modelo']); ?>" required>
        </div>

        <div class="col-md-3">
            <label class="form-label">Metros cubiertos (m²)</label>
            <input type="number" step="0.01" min="0" name="metros_cubiertos" class="form-control"
                   value="<?php echo htmlspecialchars($op['metros_cubiertos']); ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">Metros galería (m²)</label>
            <input type="number" step="0.01" min="0" name="metros_galeria" class="form-control"
                   value="<?php echo htmlspecialchars($op['metros_galeria']); ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label">Sistema</label>
            <select name="sistema" class="form-select">
                <option value="estructura" <?php echo $op['sistema'] === 'estructura' ? 'selected' : ''; ?>>
                    Estructura
                </option>
                <option value="estructura_plataforma" <?php echo $op['sistema'] === 'estructura_plataforma' ? 'selected' : ''; ?>>
                    Estructura + Plataforma
                </option>
                <option value="llave_en_mano" <?php echo $op['sistema'] === 'llave_en_mano' ? 'selected' : ''; ?>>
                    Llave en mano
                </option>
            </select>
        </div>

        <div class="col-md-3">
            <label class="form-label">Forma de venta</label>
            <select name="forma_venta" class="form-select">
                <option value="contado" <?php echo $op['forma_venta'] === 'contado' ? 'selected' : ''; ?>>
                    Contado
                </option>
                <option value="financiado" <?php echo $op['forma_venta'] === 'financiado' ? 'selected' : ''; ?>>
                    Financiado
                </option>
                <option value="mixto" <?php echo $op['forma_venta'] === 'mixto' ? 'selected' : ''; ?>>
                    Mixto
                </option>
            </select>
        </div>

        <div class="col-md-3">
            <label class="form-label">Precio de lista *</label>
            <input type="number" step="0.01" min="0" name="precio_lista" class="form-control"
                   value="<?php echo htmlspecialchars($op['precio_lista']); ?>" required>
        </div>

        <div class="col-md-3">
            <label class="form-label">Seña / entrega efectivo</label>
            <input type="number" step="0.01" min="0" name="senia" class="form-control"
                   value="<?php echo htmlspecialchars($op['senia']); ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label">Entrega vehículo</label>
            <input type="number" step="0.01" min="0" name="entrega_vehiculo" class="form-control"
                   value="<?php echo htmlspecialchars($op['entrega_vehiculo']); ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">Entrega terreno</label>
            <input type="number" step="0.01" min="0" name="entrega_terreno" class="form-control"
                   value="<?php echo htmlspecialchars($op['entrega_terreno']); ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">Entrega cheques</label>
            <input type="number" step="0.01" min="0" name="entrega_cheques" class="form-control"
                   value="<?php echo htmlspecialchars($op['entrega_cheques']); ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label">Saldo a financiar</label>
            <input type="number" step="0.01" min="0" name="saldo_financiar" class="form-control"
                   value="<?php echo htmlspecialchars($op['saldo_financiar']); ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label">Cantidad de cuotas</label>
            <input type="number" min="0" name="cuotas_cantidad" class="form-control"
                   value="<?php echo htmlspecialchars($op['cuotas_cantidad']); ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">Monto de cada cuota</label>
            <input type="number" step="0.01" min="0" name="cuota_monto" class="form-control"
                   value="<?php echo htmlspecialchars($op['cuota_monto']); ?>">
        </div>

        <div class="col-md-3">
            <label class="form-label">Tipo de plan</label>
            <select name="tipo_plan" class="form-select">
                <option value="ninguno" <?php echo $op['tipo_plan'] === 'ninguno' ? 'selected' : ''; ?>>
                    Ninguno
                </option>
                <option value="plan_ahorro" <?php echo $op['tipo_plan'] === 'plan_ahorro' ? 'selected' : ''; ?>>
                    Plan de ahorro
                </option>
            </select>
        </div>

        <div class="col-md-3">
            <label class="form-label">% inicio de obra</label>
            <input type="number" step="0.01" min="0" max="100"
                   name="porcentaje_inicio_obra" class="form-control"
                   value="<?php echo htmlspecialchars($op['porcentaje_inicio_obra']); ?>">
            <small class="text-muted">Ej: 60% (cuando llega a esto se inicia obra)</small>
        </div>

        <div class="col-md-3">
            <label class="form-label">Estado de la obra</label>
            <select name="estado_obra" class="form-select">
                <option value="pendiente" <?php echo $op['estado_obra'] === 'pendiente' ? 'selected' : ''; ?>>Pendiente</option>
                <option value="en_construccion" <?php echo $op['estado_obra'] === 'en_construccion' ? 'selected' : ''; ?>>En construcción</option>
                <option value="lista_para_entregar" <?php echo $op['estado_obra'] === 'lista_para_entregar' ? 'selected' : ''; ?>>Lista para entregar</option>
                <option value="entregada" <?php echo $op['estado_obra'] === 'entregada' ? 'selected' : ''; ?>>Entregada</option>
                <option value="cancelada" <?php echo $op['estado_obra'] === 'cancelada' ? 'selected' : ''; ?>>Cancelada</option>
            </select>
        </div>

        <div class="col-md-3">
            <label class="form-label">Fecha estimada de entrega</label>
            <input type="date" name="fecha_estimada_entrega" class="form-control"
                   value="<?php echo htmlspecialchars($op['fecha_estimada_entrega']); ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">Fecha de entrega real</label>
            <input type="date" name="fecha_entrega_real" class="form-control"
                   value="<?php echo htmlspecialchars($op['fecha_entrega_real']); ?>">
        </div>

        <div class="col-md-12">
            <label class="form-label">Observaciones</label>
            <textarea name="observaciones" class="form-control" rows="3"><?php
                echo htmlspecialchars($op['observaciones']);
            ?></textarea>
        </div>

        <div class="col-12 d-flex justify-content-between mt-3">
            <a href="operaciones.php?cliente_id=<?php echo (int)$cliente_id; ?>"
               class="btn btn-secondary">Volver</a>
            <button type="submit" class="btn btn-primary">
                Guardar operación
            </button>
        </div>
    </form>
</div>
</body>
</html>
