<?php
@session_start();
require_once '../db.php';
$pdo = pdo();

// TODO: acá después agregamos control de sesión admin

// Traer todos los modelos
$stmt = $pdo->query("
    SELECT *
    FROM modelos_casas
    ORDER BY orden ASC, created_at DESC
");
$modelos = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Modelos de Cabañas - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        .img-thumb {
            width: 120px;
            height: 80px;
            object-fit: cover;
            border-radius: 6px;
        }
    </style>
</head>
<body class="bg-light">

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Modelos de cabañas</h3>
        <a href="modelos_nuevo.php" class="btn btn-primary">+ Nuevo modelo</a>
    </div>

    <?php if (empty($modelos)): ?>
        <div class="alert alert-info">No hay modelos cargados todavía.</div>
    <?php else: ?>
        <table class="table table-striped table-bordered align-middle">
            <thead>
                <tr>
                    <th>Imagen</th>
                    <th>Nombre</th>
                    <th>Metros</th>
                    <th>Sistema</th>
                    <th>Precio desde</th>
                    <th>Activo</th>
                    <th style="width:140px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($modelos as $m): ?>
                <tr>
                    <td>
                        <?php if (!empty($m['imagen_portada'])): ?>
                            <img src="<?php echo htmlspecialchars($m['imagen_portada']); ?>" class="img-thumb">
                        <?php else: ?>
                            <span class="text-muted">Sin imagen</span>
                        <?php endif; ?>
                    </td>

                    <td><?php echo htmlspecialchars($m['nombre']); ?></td>

                    <td>
                        <?php echo $m['metros_cubiertos']; ?> m² cubiertos
                        <?php if ($m['metros_galeria'] > 0): ?>
                            + <?php echo $m['metros_galeria']; ?> m² galería
                        <?php endif; ?>
                    </td>

                    <td><?php echo htmlspecialchars($m['sistema_default']); ?></td>

                    <td>$ <?php echo number_format($m['precio_desde'], 2, ',', '.'); ?></td>

                    <td>
                        <?php if ($m['activo']): ?>
                            <span class="badge bg-success">Sí</span>
                        <?php else: ?>
                            <span class="badge bg-danger">No</span>
                        <?php endif; ?>
                    </td>

                    <td>
                        <a href="modelos_editar.php?id=<?php echo $m['id']; ?>" class="btn btn-sm btn-warning">Editar</a>
                        <a href="modelos_eliminar.php?id=<?php echo $m['id']; ?>" 
                           class="btn btn-sm btn-danger"
                           onclick="return confirm('¿Eliminar este modelo?');">
                           Eliminar
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

</body>
</html>
