<?php
@session_start();
require_once '../db.php';
$pdo = pdo();

// Validar ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    die("ID inválido");
}

// Traer datos del modelo
$stmt = $pdo->prepare("SELECT * FROM modelos_casas WHERE id = :id LIMIT 1");
$stmt->execute([':id' => $id]);
$modelo = $stmt->fetch();

if (!$modelo) {
    die("Modelo no encontrado");
}

$errores = [];
$ok = false;

// Datos iniciales
$data = [
    'nombre'             => $modelo['nombre'],
    'descripcion_corta'  => $modelo['descripcion_corta'],
    'descripcion_larga'  => $modelo['descripcion_larga'],
    'metros_cubiertos'   => $modelo['metros_cubiertos'],
    'metros_galeria'     => $modelo['metros_galeria'],
    'sistema_default'    => $modelo['sistema_default'],
    'precio_desde'       => $modelo['precio_desde'],
    'precio_lista'       => $modelo['precio_lista'],
    'activo'             => $modelo['activo'],
    'orden'              => $modelo['orden'],
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach ($data as $k => $v) {
        if (isset($_POST[$k])) {
            $data[$k] = trim($_POST[$k]);
        }
    }

    if ($data['nombre'] === '') {
        $errores[] = "El nombre es obligatorio.";
    }

    $imgPath = $modelo['imagen_portada'];

    // Imagen nueva
    if (!empty($_FILES['imagen']['name'])) {

        $dir = __DIR__ . '/uploads/modelos/';
        if (!is_dir($dir)) {
            mkdir($dir, 0777, true);
        }

        $ext = pathinfo($_FILES['imagen']['name'], PATHINFO_EXTENSION);
        $fname = 'modelo_' . time() . '_' . rand(1000,9999) . '.' . $ext;

        $dest = $dir . $fname;

        if (move_uploaded_file($_FILES['imagen']['tmp_name'], $dest)) {

            // Borrar la imagen anterior si existe
            if (!empty($modelo['imagen_portada'])) {
                $old = __DIR__ . '/' . $modelo['imagen_portada'];
                if (file_exists($old)) {
                    unlink($old);
                }
            }

            $imgPath = 'uploads/modelos/' . $fname;

        } else {
            $errores[] = "Error al subir la nueva imagen.";
        }
    }

    if (empty($errores)) {

        $stmt = $pdo->prepare("
            UPDATE modelos_casas
            SET nombre = :nombre,
                descripcion_corta = :desc_corta,
                descripcion_larga = :desc_larga,
                metros_cubiertos = :metros_cubiertos,
                metros_galeria = :metros_galeria,
                sistema_default = :sistema_default,
                precio_desde = :precio_desde,
                precio_lista = :precio_lista,
                imagen_portada = :imagen_portada,
                activo = :activo,
                orden = :orden,
                updated_at = NOW()
            WHERE id = :id
        ");

        $stmt->execute([
            ':nombre'            => $data['nombre'],
            ':desc_corta'        => $data['descripcion_corta'],
            ':desc_larga'        => $data['descripcion_larga'],
            ':metros_cubiertos'  => $data['metros_cubiertos'],
            ':metros_galeria'    => $data['metros_galeria'],
            ':sistema_default'   => $data['sistema_default'],
            ':precio_desde'      => $data['precio_desde'],
            ':precio_lista'      => $data['precio_lista'],
            ':imagen_portada'    => $imgPath,
            ':activo'            => $data['activo'],
            ':orden'             => $data['orden'],
            ':id'                => $id
        ]);

        $ok = true;

        // refrescar datos
        $stmt = $pdo->prepare("SELECT * FROM modelos_casas WHERE id = :id");
        $stmt->execute([':id' => $id]);
        $modelo = $stmt->fetch();
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar modelo - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-4">
    <h3>Editar modelo</h3>

    <?php if ($ok): ?>
        <div class="alert alert-success">Cambios guardados correctamente.</div>
    <?php endif; ?>

    <?php if (!empty($errores)): ?>
        <div class="alert alert-danger">
            <ul>
                <?php foreach ($errores as $e): ?>
                    <li><?php echo htmlspecialchars($e); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data" class="row g-3">

        <div class="col-md-6">
            <label class="form-label">Nombre *</label>
            <input type="text" name="nombre" class="form-control"
                   value="<?php echo htmlspecialchars($data['nombre']); ?>" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Reemplazar imagen portada</label>
            <input type="file" name="imagen" class="form-control">
            <?php if (!empty($modelo['imagen_portada'])): ?>
                <small class="text-muted">Imagen actual:</small><br>
                <img src="<?php echo htmlspecialchars($modelo['imagen_portada']); ?>" 
                     style="max-width:180px; margin-top:4px; border-radius:6px;">
            <?php endif; ?>
        </div>

        <div class="col-12">
            <label class="form-label">Descripción corta</label>
            <input type="text" name="descripcion_corta" class="form-control"
                   value="<?php echo htmlspecialchars($data['descripcion_corta']); ?>">
        </div>

        <div class="col-12">
            <label class="form-label">Descripción larga</label>
            <textarea name="descripcion_larga" class="form-control" rows="4"><?php
                echo htmlspecialchars($data['descripcion_larga']);
            ?></textarea>
        </div>

        <div class="col-md-4">
            <label class="form-label">Metros cubiertos *</label>
            <input type="number" step="0.01" name="metros_cubiertos" class="form-control"
                   value="<?php echo htmlspecialchars($data['metros_cubiertos']); ?>" required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Metros galería</label>
            <input type="number" step="0.01" name="metros_galeria" class="form-control"
                   value="<?php echo htmlspecialchars($data['metros_galeria']); ?>">
        </div>

        <div class="col-md-4">
            <label class="form-label">Sistema por defecto *</label>
            <select name="sistema_default" class="form-select">
                <option value="estructura" 
                    <?php echo $data['sistema_default']==='estructura'?'selected':''; ?>>
                    Estructura
                </option>

                <option value="estructura_plataforma" 
                    <?php echo $data['sistema_default']==='estructura_plataforma'?'selected':''; ?>>
                    Estructura + Plataforma
                </option>

                <option value="llave_en_mano" 
                    <?php echo $data['sistema_default']==='llave_en_mano'?'selected':''; ?>>
                    Llave en mano
                </option>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label">Precio desde *</label>
            <input type="number" step="0.01" name="precio_desde" class="form-control"
                   value="<?php echo htmlspecialchars($data['precio_desde']); ?>" required>
        </div>

        <div class="col-md-4">
            <label class="form-label">Precio lista *</label>
            <input type="number" step="0.01" name="precio_lista" class="form-control"
                   value="<?php echo htmlspecialchars($data['precio_lista']); ?>" required>
        </div>

        <div class="col-md-2">
            <label class="form-label">Activo</label>
            <select name="activo" class="form-select">
                <option value="1" <?php echo $data['activo']==1?'selected':''; ?>>Sí</option>
                <option value="0" <?php echo $data['activo']==0?'selected':''; ?>>No</option>
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Orden</label>
            <input type="number" name="orden" class="form-control"
                   value="<?php echo htmlspecialchars($data['orden']); ?>">
        </div>

        <div class="col-12 mt-3">
            <button class="btn btn-success" type="submit">Guardar cambios</button>
            <a href="modelos_listar.php" class="btn btn-secondary">Volver</a>
        </div>

    </form>
</div>

</body>
</html>
