<?php
// admin/clientes.php
@session_start();
if (empty($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../db.php';
$pdo = pdo();

// Búsqueda simple por nombre/apellido/DNI
$busqueda = trim($_GET['q'] ?? '');
$params   = [];
$where    = '';

if ($busqueda !== '') {
    $where = "WHERE (nombre LIKE :q OR apellido LIKE :q OR dni LIKE :q)";
    $params[':q'] = '%' . $busqueda . '%';
}

$sql = "SELECT * FROM clientes $where ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$clientes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Clientes - Cabañas Santiago</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="panel.php">Cabañas Santiago - Admin</a>
        <div class="d-flex">
            <a class="btn btn-outline-light btn-sm me-2" href="clientes.php">Clientes</a>
            <a class="btn btn-outline-light btn-sm" href="logout.php">Salir</a>
        </div>
    </div>
</nav>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="mb-0">Clientes</h3>
        <a href="cliente_form.php" class="btn btn-success">
            + Nuevo cliente
        </a>
    </div>

    <form class="row g-2 mb-3" method="get">
        <div class="col-md-4">
            <input type="text" name="q" class="form-control"
                   placeholder="Buscar por nombre, apellido o DNI"
                   value="<?php echo htmlspecialchars($busqueda); ?>">
        </div>
        <div class="col-md-2">
            <button class="btn btn-outline-primary w-100" type="submit">Buscar</button>
        </div>
        <?php if ($busqueda !== ''): ?>
            <div class="col-md-2">
                <a href="clientes.php" class="btn btn-outline-secondary w-100">Limpiar</a>
            </div>
        <?php endif; ?>
    </form>

    <?php if (empty($clientes)): ?>
        <div class="alert alert-info">No se encontraron clientes.</div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-sm table-striped align-middle">
                <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>DNI</th>
                    <th>Teléfono</th>
                    <th>Localidad</th>
                    <th>Estado</th>
                    <th style="width: 120px;">Acciones</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($clientes as $c): ?>
                    <tr>
                        <td><?php echo (int)$c['id']; ?></td>
                        <td>
                            <?php echo htmlspecialchars($c['apellido'] . ', ' . $c['nombre']); ?><br>
                            <small class="text-muted">
                                <?php
                                if (!empty($c['email'])) {
                                    echo htmlspecialchars($c['email']);
                                }
                                ?>
                            </small>
                        </td>
                        <td><?php echo htmlspecialchars($c['dni']); ?></td>
                        <td><?php echo htmlspecialchars($c['telefono']); ?></td>
                        <td>
                            <?php
                            $loc = trim(($c['localidad'] ?? '') . ' ' . ($c['provincia'] ?? ''));
                            echo htmlspecialchars($loc);
                            ?>
                        </td>
                        <td>
                            
                            <?php if ($c['estado'] === 'activo'): ?>
                                <span class="badge bg-success">Activo</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactivo</span>
                            <?php endif; ?>
                        </td>
                        <td>
                        
    <a href="cliente_form.php?id=<?php echo (int)$c['id']; ?>"
       class="btn btn-sm btn-primary mb-1">Editar</a>
    <a href="operaciones.php?cliente_id=<?php echo (int)$c['id']; ?>"
       class="btn btn-sm btn-outline-secondary mb-1">Operaciones</a>
</td>

                        </td>
                    </tr>
                <?php endforeach; ?>
                
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
